#ifndef _HYSTERESIS_H_
#define _HYSTERESIS_H_

#include <stdint.h>

namespace amakusa
{
/**
* @brief Hysteresis algorithm to the descrete input value. 
* @details
* To use this class, include amakusa.h
*/
    class Hysteresis
    {
    public:
            /**
            * @brief Constructor
            * @param[in] min_input the Minumum input value for run() method. Must be smaller than INT32_MAX.
            * @param[in] max_input the Maximum input value for run() method. Must be bigger than INT32_MIN.
            */
        Hysteresis( int32_t min_input, int32_t max_input );
            /**
            * @brief Run the Hysteresis algorithm
            * @param[in] in_data A data to be applied hysteresis
            * @returns data with hysteresis. The value range is [min_input, max_input ] of the constructor. 
            */
        virtual int32_t run( int32_t in_data  );
    private:
        int32_t last_value, min, max;
    };
    
}


#endif