#ifndef _firinterpolator_h_
#define _firinterpolator_h_

#include "abstractfilter.h"
namespace amakusa
{
/**
* @brief Wrapper class of the arm_fir_interpolate_f32() and the arm_fir_interpolate_init_f32().
* @details
* To use this class, include amakusa.h
*/
    class FIRInterpolator : public AbstractFilter
    {
    public:
            /**
            * @brief Constructor
            * @param[in] taps Number of the elements in the coeffisients array. Or length of the impuls response. The taps must be integer multiple of L
            * @param[in] pCoeff Ponter to the coefficients array ( Impuls response ).
            * @param[in] block_size Maximum number of the input samples to be given to run() method at onece. 
            * @param[in] L Up sampling ratio 
            */
        FIRInterpolator(uint16_t taps, float32_t *pCoeff, uint32_t block_size, uint8_t L);
            /**
            * Destructor
            */
        virtual ~FIRInterpolator();
            /**
            * @brief Run the filter.
            * @param[in] pSrc Pointer to the source buffer to be filtered.
            * @param[out] pDst Pointer to the destination buffer to store the filtered signal. 
            */
        virtual void run( float32_t *pSrc, float32_t *pDst);
    private:
        arm_fir_interpolate_instance_f32 state;
    };
    
}

#endif
