#include "amakusa.h"

amakusa::FIRDecimator::FIRDecimator(uint16_t taps, float32_t *pCoeff, uint32_t block_size, uint8_t m )
     : AbstractFilter( block_size )
{
    arm_fir_decimate_init_f32( 
        &(this->state),
        taps, 
        m,
        pCoeff,
        new float32_t[taps+block_size-1],
        block_size);
}

amakusa::FIRDecimator::~FIRDecimator()
{
    delete [] this->state.pState;
}
void amakusa::FIRDecimator::run( float32_t *pSrc, float32_t *pDst )
{
    arm_fir_decimate_f32( 
        & this->state, 
        pSrc, 
        pDst, 
        this->block_size
        );
}