#ifndef _BIQUADCASCADEDF2T_H_
#define _BIQUADCASCADEDF2T_H_

#include "abstractfilter.h"
namespace amakusa
{
/**
* @brief Wrapper class of the arm_biquad_cascade_df2T_f32() and the arm_biquad_cascade_df2T_init_f32().
* @details
* To use this class, include amakusa.h
*
* The biquad filter is depicted as following. The pCoeff array has b0, b1, b2, a1, a2 parameter
* by this order. If the stage is N, N blockes of these parameers are given. The length of pCoeff
* is 5N. 
* @code
x[n]---+-- b0 -->+---------+---y[n]
       |         ^         |
       |         D         |
       +-- b1 -->+<-- a1 --+
       |         D         |
       +-- b2 -->+<-- a2 --+
* @endcode
*/
    class BiQuadCascadeDF2T : public AbstractFilter
    {
    public:
            /**
            * @brief Constructor
            * @param[in] stages Number of the Bi-Quad stages. 
            * @param[in] pCoeff Ponter to the coefficients array.
            * @param[in] blockSize Maximum number of the samples to be given to run() method at onece. 
            */
        BiQuadCascadeDF2T(uint16_t stages, float32_t *pCoeff, uint32_t block_size);
            /**
            * Destructor
            */
        virtual ~BiQuadCascadeDF2T();
            /**
            * @brief Run the filter.
            * @param[in] pSrc Pointer to the source buffer to be filtered.
            * @param[out] pDst Pointer to the destination buffer to store the filtered signal. 
            */
        virtual void run( float32_t *pSrc, float32_t *pDst);
    private:
        arm_biquad_cascade_df2T_instance_f32 state;
    };
    
}

#endif