#include "amakusa.h"

#define ROUND_OFFSET 0x2

amakusa::Hysteresis::Hysteresis( int32_t min_input, int32_t max_input )
{
    this->min = min_input;
    this->max = max_input;
    this->last_value = 0;
}

int32_t amakusa::Hysteresis::run(int32_t in_data)
{
    if ( in_data == this->last_value )
        ;   // do nothing;
    else 
        this->last_value = ( in_data + ROUND_OFFSET  + ( in_data > this->last_value ? - 1 : 1 ) ) & 0xFFFFFFFC;
        
    if ( this->last_value > this->max )
        this->last_value = this->max;
    else if ( this->last_value < this->min )
        this->last_value = this->min;
        
    return this->last_value;
}