#include "amakusa.h"

amakusa::FIRInterpolator::FIRInterpolator(uint16_t taps, float32_t *pCoeff, uint32_t block_size, uint8_t L )
     : AbstractFilter( block_size )
{
    arm_fir_interpolate_init_f32( 
        &(this->state),
        L,
        taps, 
        pCoeff,
        new float32_t[taps/L+block_size-1],
        block_size);
}

amakusa::FIRInterpolator::~FIRInterpolator()
{
    delete [] this->state.pState;
}
void amakusa::FIRInterpolator::run( float32_t *pSrc, float32_t *pDst )
{
    arm_fir_interpolate_f32( 
        & this->state, 
        pSrc, 
        pDst, 
        this->block_size
        );
}