#include "amakusa.h"

amakusa::FIRFilter::FIRFilter(uint16_t taps, float32_t *pCoeff, uint32_t block_size)
     : AbstractFilter( block_size )
{
    arm_fir_init_f32( 
        &(this->state),
        taps, 
        pCoeff,
        new float32_t[taps+block_size-1],
        block_size);
}

amakusa::FIRFilter::~FIRFilter()
{
    delete [] this->state.pState;
}
void amakusa::FIRFilter::run( float32_t *pSrc, float32_t *pDst )
{
    arm_fir_f32( 
        & this->state, 
        pSrc, 
        pDst, 
        this->block_size
        );
}