#include "amakusa.h"

amakusa::BiQuadCascadeDF2T::BiQuadCascadeDF2T(uint16_t stages, float32_t *pCoeff, uint32_t block_size)
     : AbstractFilter( block_size )
{
    arm_biquad_cascade_df2T_init_f32( 
        &(this->state),
        stages, 
        pCoeff,
        new float32_t[stages*2]
        );
}

amakusa::BiQuadCascadeDF2T::~BiQuadCascadeDF2T()
{
    delete [] this->state.pState;
}
void amakusa::BiQuadCascadeDF2T::run( float32_t *pSrc, float32_t *pDst)
{
    arm_biquad_cascade_df2T_f32( 
        & this->state, 
        pSrc, 
        pDst, 
        this->block_size
        );
}