#include "amakusa.h"

amakusa::BiQuadCascadeDF1::BiQuadCascadeDF1(uint16_t stages, float32_t *pCoeff, uint32_t block_size)
     : AbstractFilter( block_size )
{
    arm_biquad_cascade_df1_init_f32( 
        &(this->state),
        stages, 
        pCoeff,
        new float32_t[stages*4]
        );
}

amakusa::BiQuadCascadeDF1::~BiQuadCascadeDF1()
{
    delete [] this->state.pState;
}
void amakusa::BiQuadCascadeDF1::run( float32_t *pSrc, float32_t *pDst )
{
    arm_biquad_cascade_df1_f32( 
        & this->state, 
        pSrc, 
        pDst, 
        this->block_size
        );
}