#include "mbed.h"
#include "HTTPClient.h"
#include <string>
using namespace std;

Serial pc(USBTX, USBRX);

DigitalOut led1(LED1); // blink
DigitalOut led2(LED2); // blink when http-post
DigitalOut led3(p11); // represent ADC value

AnalogIn adc(p15);
float ain;

HTTPClient http; // use DHCP

const string api_uri = "http://shokai.mag.keio.ac.jp/sensor-storage/shokai/cds/";
const string mbed_name = "shokai-mbed01";
const string sensor_name = "CdS";

void blink_led(DigitalOut led, int num){
    for(int i=0; i < num*2; i++){
        led = !led;
        wait(0.1);
    }
}

void post_sensor_value(){
    blink_led(led2, 2);
    char query[256] = "";
    char result[4096] = ""; // 4kb
    sprintf(query, "name=%s&%s=%f", mbed_name.c_str(), sensor_name.c_str(), (float)ain);
    pc.printf("post:%s => %s\n", query, api_uri.c_str());
    http.post(api_uri.c_str(), query, result, 4096);
    pc.printf("%s\n", result);
    blink_led(led2, 2);
}

int main(void){
    led1 = 1;
    int count = 0;
    while(1) {
        ain = adc;
        pc.printf("sensor:%f\n", float(ain));
        led1 = !led1; // blink LED
        if(ain > 0.1) led3 = 0; // represent CdS value
        else led3 = 1;
        if(count > 20){
            post_sensor_value();
            count = 0;
        }
        count++;
        wait(0.5);
    }
}
