#ifndef LD8035_H
#define LD8035_H

#include "mbed.h"

#define G_SIZE 6
#define WAIT_TIME 3

class LD8035
{
public:

    LD8035(PinName G1, PinName G2, PinName G3, PinName G4, PinName G5, PinName G6,
           PinName a_pin, PinName b_pin, PinName c_pin, PinName d_pin, PinName e_pin,
           PinName f_pin, PinName g_pin, PinName dot_pin, PinName hyphen_pin);

    void set_bars(int numbers[],bool dot_flags[],bool hyphen_flags[]);
    void clear();
    void flush();

private:
    BusOut _GPin;
    BusOut _NumPin;
    BusOut _DotPin;
    BusOut _HyphenPin;

    int _numbers[G_SIZE];
    bool _dot_flags[G_SIZE];
    bool _hyphen_flags[G_SIZE];
};

#endif