#include "LD8035.h"
#include "mbed.h"

LD8035::LD8035(PinName G1, PinName G2, PinName G3, PinName G4, PinName G5, PinName G6,
               PinName a_pin, PinName b_pin, PinName c_pin, PinName d_pin, PinName e_pin,
               PinName f_pin, PinName g_pin, PinName dot_pin, PinName hyphen_pin)
    : _GPin(G1,G2,G3,G4,G5,G6), _NumPin(a_pin,b_pin,c_pin,d_pin,e_pin,f_pin,g_pin), _DotPin(dot_pin), _HyphenPin(hyphen_pin)
{
    clear();
}

void LD8035::set_bars(int numbers[], bool dot_flags[], bool hyphen_flags[])
{
    for(int i = 0 ; i < G_SIZE ; i++) {
        _numbers[i] = numbers[i];
        _dot_flags[i] = dot_flags[i];
        _hyphen_flags[i] = hyphen_flags[i];
    }
}

void LD8035::clear()
{
    _NumPin = 0x00;
}

void LD8035::flush()
{
    for(int j = 0 ; j < 10 ; j++) {
        for(int i = 0 ; i < G_SIZE ; i++) {
            clear();
            _GPin = 1 << i;
            switch(_numbers[i]) {
                case 0:
                    _NumPin = 0x3f;
                    break;
                case 1:
                    _NumPin = 0x06;
                    break;
                case 2:
                    _NumPin = 0x5b;
                    break;
                case 3:
                    _NumPin = 0x4f;
                    break;
                case 4:
                    _NumPin = 0x66;
                    break;
                case 5:
                    _NumPin = 0x6d;
                    break;
                case 6:
                    _NumPin = 0x7d;
                    break;
                case 7:
                    _NumPin = 0x27;
                    break;
                case 8:
                    _NumPin = 0x7f;
                    break;
                case 9:
                    _NumPin = 0x6f;
                    break;
                default:
                    _NumPin = 0x79;
                    break;
            }
            if(_dot_flags[i] == true) {
                _DotPin = 1;
            } else {
                _DotPin = 0;
            }
            if(_hyphen_flags[i] == true) {
                _HyphenPin = 1;
            } else {
                _HyphenPin = 0;
            }
            wait_ms(WAIT_TIME);
        }
    }
}

