/*
*    
*
*
*    PS3をSBDBTで使うときにでも使ってください(mbed LPC1768用、UART使用)
*
*    =====使い方=====
*   動作クロックは20MHz(それ以外でやる時は通信速度が2500bpsになるように調整してちょ)
*   まずPS3DefaultSetを一回実行してください。USARTレジスタの設定と構造体の初期化を行います。
*
*    メインループでCheckInputData関数を一回実行してください。ボタンからのデータがpsdata配列(グローバル)に格納されます。
*   if文の条件式に、BTTRUE(***)またはBTFALSE(***)をぶち込んでください。
*   ***には各ボタンに対応した構造体の名前が入ります。
*
*       (例)□ボタンが押されたときに処理したいとき
*           if(BTTRUE(SQUARE)){
*                   処理;
*           }
*
*
*   スティックに関しては、psdata配列から該当するバイトを丸ごと読んでください。
*   64がニュートラル、0が下端、127が上端です。
*
*       (例)右スティック縦軸が半分以上前に倒されている時に処理したいとき
*       if(RIGHT_VERTICAL > 80){
*           処理; 
*       }
*
*   BTTOGGE関数は「ボタンが押されたら一回だけ実行したい処理」を処理するときに使ってください。
*   押されるたびに変形するときとか
*
*   
*/

/*
* ボタン対応一覧
*
* ○ボタン          CIRCLE
* ×ボタン          CROSS
* □ボタン          SQUARE
* △ボタン          TRIANGLE
* 十字キー上     UP
* 十字キー下     DOWN
* 十字キー右     RIGHT
* 十字キー左     LEFT
* L1ボタン         L1
* L2ボタン         L2
* R1ボタン         R1
* R2ボタン         R2
* 右スティック縦軸  RIGHT_VERTICAL
* 右スティック横軸  RIGHT_WYDE
* 左スティック縦軸  LEFT_VERTICAL
* 左スティック横軸  LEFT_WYDE
*
*/



/************************************************************************/
/* 構造体宣言                                                            */
/************************************************************************/
typedef struct{
    int storebyte;      //何バイト目か
    uint8_t data;       //データ
    int toggleflag;     //BTTOGGLEで使うフラグ
} ps3;


/************************************************************************/
/* define スティック(何バイト目か)                                     */
/************************************************************************/
#define LEFT_WYDE           psdata[3]   //左横軸
#define LEFT_VERTICAL       psdata[4]   //左縦軸
#define RIGHT_WYDE          psdata[5]   //右横軸
#define RIGHT_VERTICAL      psdata[6]   //右縦軸

/************************************************************************/
/* define 処理                                                          */
/************************************************************************/
#define BTTRUE(Target)      CheckBT(Target) == 1        //Targetで指定されたボタンが押されているか判定するifの条件式
#define BTFALSE(Target)     CheckBT(Target) == 0
#define BTTOGGLE(Target)    ToggleBT(&Target) == 1      //Targetが押されたら一回だけ実行する

/************************************************************************/
/* define その他                                                        */
/************************************************************************/
#define ERROR               1           //受信エラー
#define SUCCESS             0           //正常に受信

/************************************************************************/
/* グローバル変数宣言                                                    */
/************************************************************************/
volatile uint8_t psdata[8];                                         //コントローラーからのデータを格納
ps3 SQUARE,TRIANGLE,CIRCLE,CROSS,UP,DOWN,LEFT,RIGHT,L1,L2,R1,R2;    //各ボタンに対応したデータが入ってる構造体×12

/************************************************************************/
/* プロトタイプ宣言                                                     */
/************************************************************************/
int  CheckBT(ps3);                  //ボタン入力判定
void CheckInputData(void);          //受信用関数
int  ToggleBT(ps3 *TargetBT);       //ボタンが押されたら一回だけ1を返す関数
void PS3DefaultSet(void);           //設定初期化
int  CheckError(void);              //エラーチェック 

/************************************************************************/
/* レジスタ初期設定関数                                                 */
/************************************************************************/

Serial ps3com(p28,p27);      //シリアルピン27，28使用
void PS3DefaultSet(void){
    /*
    *レジスタの初期設定を行う関数
    *プログラムの最初に一回実行してください
    *mbed LPC以外を使う場合や20MHz以外の動作クロックでやる場合はこの関数をいじってください
    */
    
        /**********UARTレジスタ設定**********/
                  
        //受信完了割り込み禁止、送信割り込み禁止、受信許可、送信禁止
    ps3com.format(8,Serial::None,1);    
    //UART、パリティなし、停止ビット1、データビット8
    ps3com.baud(2400);//通信速度2400bps

        /**********構造体の初期化**********/
        
        SQUARE.storebyte     = 1;
        TRIANGLE.storebyte   = 2;
        CIRCLE.storebyte     = 2;
        CROSS.storebyte      = 2;
        UP.storebyte         = 2;
        DOWN.storebyte       = 2;
        LEFT.storebyte       = 2;
        RIGHT.storebyte      = 2;
        L1.storebyte         = 1;
        L2.storebyte         = 1;
        R1.storebyte         = 1;
        R2.storebyte         = 1;
        
        UP.data             = 0b00000001;               //十字キー上
        DOWN.data           = 0b00000010;               //十字キー下
        RIGHT.data          = 0b00000100;               //十字キー右
        LEFT.data           = 0b00001000;               //十字キー左
        TRIANGLE.data       = 0b00010000;               //△ボタン
        CROSS.data          = 0b00100000;               //×ボタン
        CIRCLE.data         = 0b01000000;               //○ボタン
        SQUARE.data         = 0b00000001;               //□ボタン
        L1.data             = 0b00000010;               //L1ボタン
        L2.data             = 0b00000100;               //L2ボタン
        R1.data             = 0b00001000;               //R1ボタン
        R2.data             = 0b00010000;               //R2ボタン
        
        SQUARE.toggleflag    = 0;
        TRIANGLE.toggleflag  = 0;
        CIRCLE.toggleflag    = 0;
        CROSS.toggleflag     = 0;
        UP.toggleflag        = 0;
        DOWN.toggleflag      = 0;
        LEFT.toggleflag      = 0;
        RIGHT.toggleflag     = 0;
        L1.toggleflag        = 0;
        L2.toggleflag        = 0;
        R1.toggleflag        = 0;
        R2.toggleflag        = 0;

}


/************************************************************************/
/* ボタンチェック関数                                                   */
/************************************************************************/
int CheckBT(ps3 TargetBT){                      //構造体でデータぶっこむ
    
    /*****指定されたボタンが押されているか判定して0か1を返す関数*****/
    
    uint8_t ConpareData;
    
    ConpareData = psdata[TargetBT.storebyte] & TargetBT.data;
    
    if(ConpareData == TargetBT.data){
        return 1;       //押されていたら
    }else{
        return 0;       //押されていなかったら
    }

}


/************************************************************************/
/* ボタントグル判定関数                                                 */
/************************************************************************/
int ToggleBT(ps3 *TargetBT){
    
    if(BTTRUE(*TargetBT)){
        if(TargetBT->toggleflag == 0){
            TargetBT->toggleflag = 1;
            return 1;
        }
        
    }else{
        TargetBT->toggleflag = 0;
    }
    
    return 0;
}

/************************************************************************/
/* 受信データ処理関数                                                   */
/************************************************************************/
void CheckInputData(){
    //ps3からのデータをpsdata配列に格納する関数
    int i;
    int flg;
    
    
    
   // do{         
        while(LPC_UART2->RBR!= 0x80);          //第一バイトが来るまで待つ
        
        for(i=0;i<=7;i++){
            psdata[i] =LPC_UART2->RBR;
            flg=LPC_UART2->LSR & 0x01;
            while(flg!=0x01){
                flg=LPC_UART2->LSR & 0x01;
                }                        //受信完了フラグが立つまで待つ
        }
      
        
   //     chechsum = CheckError();                //エラーチェック
    //}while(chechsum == ERROR);                  //受信失敗したらリトライ
}