#include "mbed.h"
#include "ps3CTRLmbed.h"
/*
上　下    1.0
〇　一気に発射
R1 発射1
L1 発射2
R2 発射3
L2 発射4
△ 発射5
□  発射6
*/
DigitalOut TRD(p14);
DigitalOut SQD(p15);
DigitalOut UDD(p16);
DigitalOut RD(p17);
DigitalOut RRD(p18);
DigitalOut LD(p19);
DigitalOut LLD(p20);

PwmOut UDP(p21);

I2C i2c(p9,p10);

int addr=0x00;//アドレスをいじるならここ
int ack=0;
double t1=0;

int main() {
    char cmd[4];
    PS3DefaultSet();
    while(1) {
        CheckInputData();
        for(int i=0;i<4;i++){
            cmd[i]=(char)psdata[i+3];
        }
        i2c.write(addr,cmd,4);
        
        /*上下*/
        if(BTTRUE(UP)){/*上*/
            t1+=0.2;
            if(t1>1.0){
                t1=1.0;
            }
            UDD=0;
            UDP=t1;
        }else if(BTTRUE(DOWN)){/*下*/
            t1+=0.2;
            if(t1>1.0){
                t1=1.0;
            }
            UDD=1;
            UDP=t1;
        }else{
            t1-=0.2;
            if(t1<0){
                t1=0.0;
            }
            UDP=t1;
        }
        
        if(BTTRUE(CIRCLE)){
            RD=0;
            LD=0;
            RRD=0;
            LLD=0;
            TRD=0;
            SQD=0;
        }else{
            if(BTTRUE(SQUARE)){
                SQD=0;
            }else{
                SQD=1;
            }
            
            if(BTTRUE(TRIANGLE)){
                TRD=0;
            }else{
                TRD=1;
            }
            
            if(BTTRUE(L2)){
                LLD=0;
            }else{
                LLD=1;
            }
            
            if(BTTRUE(R2)){
                RRD=0;
            }else{
                RRD=1;
            }
            
            if(BTTRUE(R1)){
                RD=0;
            }else{
                RD=1;
            }
        
            if(BTTRUE(L1)){
                LD=0;
            }else{
                LD=1;
            }
        }
        
    }
}