#include "mbed.h"

#define HIGH    1
#define LOW     0
// connect N3290X by UART
//Serial pc(USBTX, USBRX); // tx, rx



#if defined(TARGET_NUMAKER_PFM_NUC472)
// The following definitions of LED and serial are for NUC472
DigitalOut led1(LED1);
Serial device(D1, D0);  // tx, rx
DigitalIn button(SW1); // SW1 is OK

#elif defined(TARGET_NUMAKER_PFM_M453)
// The following definitions of LED and serial are for NUC_M453
DigitalOut led1(LED1);
Serial device(D1, D0);  // tx, rx
DigitalIn button(SW2); // SW2 is OK

#elif defined(TARGET_K64F)
// The following definitions of LED and serial are for K64F

DigitalOut led1(LED_GREEN);
Serial device(PTC17, PTC16);  // tx, rx
DigitalIn button(SW2); // SW2 is OK

#elif defined(TARGET_NUCLEO_F401RE)

//The following definitions are for STM32F401
DigitalOut led1(LED3);
Serial device(D8,D2);
DigitalIn button(USER_BUTTON); // User button is OK

#endif

void setupCommand(int number)
{
    int no, readByte,i;
    no = '0'+ number;
    
    device.putc(no);
    Thread::wait(1000);
    while (1)
    {
        no = device.readable(); 
        if ( no > 0 )
        {
            readByte = device.getc();
            if (readByte == 0x39 ) // '9'
            {
                for (i=0; i<3; i++)
                { 
                    led1 = !led1;
                    Thread::wait(200);
                    led1 = !led1; 
                    Thread::wait(200);
                }
            }
        }
        else
            break;
  }
}
 
int main() {
    int buttonState;
    int inByte;         // incoming serial byte
    int ifound;
    int sendnum;
    
//    pc.baud(115200);
//    pc.printf("Hello World!\n");

    device.baud(115200);
    inByte= 0;
    ifound = 0;
    sendnum =0;
    
    led1= 0;
    while (1)
    {
        buttonState = button.read();
        if (buttonState == HIGH ) {
    // turn LED on:
            if ( ifound == 1 )
            {
                sendnum++;
                setupCommand(inByte);
                ifound = 0;
                inByte = 0;
            }
        } 
        else
        {
      // turn LED off:
            led1=!led1;
            inByte++;
            ifound=1;
            Thread::wait(200);
            led1=!led1;
        }
        Thread::wait(500);
    }
}
