#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPServer.h"
#include "TCPSocket.h"
#include "SN74CBT3257.h"
#include "Binary_Switch.h"
#include "7segLed_HC595.h"

#define NUM_OF_DIGIT 4


#define IP         "192.168.1.190"
#define GATEWAY    "192.168.1.1"
#define MASK       "255.255.255.0"

 int   Validate_Recieved_Packet(char *Packet,int *num0, int *num1, int * num2,int *num3,
                                int * num4, int *num5, int *num6, int *num7);
                                
Serial pc(USBTX,USBRX);
SN74CBT3257  Bus(PD_0,PD_1,PD_2,PD_3,PD_4,PD_5,PD_6,PD_7 );
BinarySwitch  Switch(PD_8,PD_9,PD_10,PD_11,PD_12,PD_13,PD_14,PD_15);
SevenSegLed led_7segs(PC_12,PC_10, PC_9, PC_8,  NUM_OF_DIGIT);
                             
int main()
{
   
    int N0,N1,N2,N3;
    int N4,N5,N6,N7;
    int  valid=0;
    int SUCCESS=-1;
    printf("TCP server example\n");
    
    EthernetInterface eth;
    SocketAddress sockaddr;
    
     //eth.disconnect();
    int i=eth.set_network(IP,MASK,GATEWAY);
    printf("set IP status: %i \r\n",i);
    i=eth.connect();
    printf("connect status: %i \r\n",i);
    const char *ip = eth.get_ip_address();
    const char *mac = eth.get_mac_address();
    printf("IP address is: %s\n\r", ip ? ip : "No IP");
    printf("MAC address is: %s\n\r", mac ? mac : "No MAC");
    
    printf("set IP status: %i \r\n",i);    
    printf("The Server IP address is '%s'\n", eth.get_ip_address());
    
    TCPServer srv;
    TCPSocket client_sock;
    SocketAddress client_addr;
    char buffer[200] = {'\0'};
    char Rx_buffer[200] = {'\0'};  
    /* Open the server on ethernet stack */
    srv.open(&eth);
    
    /* Bind the HTTP port (TCP 80) to the server */
    srv.bind(eth.get_ip_address(), 23);
    
    /* Can handle x simultaneous connections */
   
    srv.listen(1);

while(true)
{
    srv.accept(&client_sock, &client_addr);
    printf("Accepted %s:%d\n", client_addr.get_ip_address(), 
                    client_addr.get_port());
    strcpy(buffer, "Hello \n\r");
   SUCCESS= client_sock.send(buffer, strlen(buffer));
   if(SUCCESS>=1)
   {
      printf("Sent : %s\r\n",buffer);
    SUCCESS=client_sock.recv(Rx_buffer, 200); 
    }
    
    if(SUCCESS>=1)
    {
    printf("Recieved : %s\r\n",Rx_buffer);
    printf("Am Here \r\n");  
    }
   // int Floor=Switch.Read_Switch_State();
//    printf("   You are in Floor number %d : \r\n",Floor); 
    
    valid= Validate_Recieved_Packet(Rx_buffer,&N0,&N1,&N2,&N3,&N4,&N5,&N6,&N7); 
    if(valid==1 && SUCCESS>=1)
    {
        valid=-1 ;SUCCESS=-1;
        wait(0.1);
    Bus.Select_Floor_Zero();
  
    led_7segs=N0;
    printf("Floor 0 Bays Available :%d \r\n",N0);
    Bus.Select_Floor_One();
    led_7segs=N1;
     wait(0.1);
     
    printf("Floor 1 Bays Available : %d\r\n",N1);
    Bus.Select_Floor_Two();
    led_7segs=N2;
    wait(0.1);
    printf("Floor 2 Bays Available : %d\r\n",N2);
    Bus.Select_Floor_Three();
    led_7segs=N3;
    wait(0.1);
    printf("Floor 3 Bays Available : %d\r\n",N3);
    
    Bus.Select_Floor_Four();
    led_7segs=N4;
    printf("Floor 4 ays Available : %d\r\n",N4);
    Bus.Select_Floor_Five();
    led_7segs=N5;
    printf("Floor 5 ays Available : %d\r\n",N5);
    Bus.Select_Floor_Six();
    led_7segs=N6;
    wait(0.1);
    printf("Floor 6 ays Available : %d\r\n",N6);
    Bus.Select_Floor_Seven();
    led_7segs=N7;
    wait(0.1);
    printf("Floor 7 ays Available : %d\r\n",N7);
    wait(1);
    }
     client_sock.close();
    }
    
}

 int   Validate_Recieved_Packet(char *Packet,int *num0, int *num1, int *num2,int *num3,
                                int *num4, int *num5, int *num6, int *num7)
{   
  if( Packet[0]=='E'  && Packet[1]=='S'  && Packet[2]=='T'  && Packet[3]=='S'  
                      && Packet[4]==' '   && Packet[12]==',' && Packet[20]==',' && Packet[28]==',' 
                      && Packet[36]==',' && Packet[44]==','  && Packet[52]==',' && Packet[60]==',' 
                      && Packet[68]==' ' && Packet[69]=='E' && Packet[70]=='S'  && Packet[71]=='T' 
                      && Packet[72]=='E')
   
   { 
    printf("Valid Data R4ecieved \r\n");  
    
    if(Packet[5]=='0' && Packet[6]=='0')
         { 
            printf("Zeroth Floor  \r\n"); 
            int one,two,three,four; 
            four=Packet[8]-0x30;
            three=Packet[9]-0x30;
            two=Packet[10]-0x30;
            one=Packet[11]-0x30;
            *num0=four*1000+three*100+two*10+one;
        }      
   
    if(Packet[13]=='0' && Packet[14]=='1')
         { 
            printf("First Floor  \r\n"); 
            int one,two,three,four; 
            four=Packet[16]-0x30;
            three=Packet[17]-0x30;
            two=Packet[18]-0x30;
            one=Packet[19]-0x30;
            *num1=four*1000+three*100+two*10+one;
        }    
     
     if(Packet[21]=='0' && Packet[22]=='2')
        { 
            printf("Second Floor  \r\n"); 
            int one,two,three,four; 
            four=Packet[24]-0x30;
            three=Packet[25]-0x30;
            two=Packet[26]-0x30;
            one=Packet[27]-0x30;
            *num2=four*1000+three*100+two*10+one;
        }          
           
    if(Packet[29]=='0' && Packet[30]=='3')
        { 
            printf("Three Floor  \r\n"); 
            int one,two,three,four; 
            four=Packet[32]-0x30;
            three=Packet[33]-0x30;
            two=Packet[34]-0x30;
            one=Packet[35]-0x30;
            *num3=four*1000+three*100+two*10+one;
        }       
   
   if(Packet[37]=='0' && Packet[38]=='4')
        { 
            printf("Fourth Floor  \r\n"); 
            int one,two,three,four; 
            four=Packet[40]-0x30;
            three=Packet[41]-0x30;
            two=Packet[42]-0x30;
            one=Packet[43]-0x30;
            *num4=four*1000+three*100+two*10+one;
        }   
   
    if(Packet[45]=='0' && Packet[46]=='5')
        { 
             printf("Fifth Floor  \r\n"); 
            int one,two,three,four; 
            four=Packet[48]-0x30;
            three=Packet[49]-0x30;
            two=Packet[50]-0x30;
            one=Packet[51]-0x30;
            *num5=four*1000+three*100+two*10+one;
        }   
   
   if(Packet[53]=='0' && Packet[54]=='6')
        { 
            printf("Sixth Floor  \r\n"); 
            int one,two,three,four; 
            four=Packet[56]-0x30;
            three=Packet[57]-0x30;
            two=Packet[58]-0x30;
            one=Packet[59]-0x30;
            *num6=four*1000+three*100+two*10+one;
        }    
   
    if(Packet[61]=='0' && Packet[62]=='7')
        { 
            int one,two,three,four; 
            four=Packet[64]-0x30;
            three=Packet[65]-0x30;
            two=Packet[66]-0x30;
            one=Packet[67]-0x30;
            *num7=four*1000+three*100+two*10+one;
            printf("Seventh Floor :  \r\n"); 
        }   
        return 1;     
   }
   else
   {
     return -1;  
    }
}



int Validate_Card_Reply_Packet(char *rbuffer,char *barc_string)
{
    int i=0,j=0;
    if(rbuffer[0]=='1' &&rbuffer[1]=='1' && rbuffer[2]=='1' &&rbuffer[3]=='1'
            && rbuffer[4]==':' &&rbuffer[19]==',' && rbuffer[20]=='C' &&
               rbuffer[21]=='A' && rbuffer[22]=='R'  && rbuffer[23]=='D' && rbuffer[24]==',')

    {
        //printf("Valid card ................................Reply \r\n");
        i=25;
        while(rbuffer[i]!=',')
         {
            if(rbuffer[i]=='\r'|rbuffer[i]=='\n') {
                i++;
            }
            else {
                barc_string[j]=rbuffer[i];
                i++;
                j++;
            }
         } 
        barc_string[i++]='\0';
        //printf(" Valid card reply:%s",barc_string);
        return j;
    } 
    else
        return 0;
       
}



