#include "mbed.h"
#include "USBHostMSD.h"
#include "USBHostMouse.h"
#include "USBHostKeyboard.h"
#include "FATFileSystem.h"
#include <stdlib.h>


DigitalOut led(LED1);
 int index=0;
char Barcode[50];
void onMouseEvent(uint8_t buttons, int8_t x, int8_t y, int8_t z) {
    printf("buttons: %d, x: %d, y: %d, z: %d\r\n", buttons, x, y, z);
}
 
void mouse_task(void const *) {

    USBHostMouse mouse;
    printf("mouse started\n");
    while(1) {
       
        // try to connect a USB mouse
        while(!mouse.connect())
            Thread::wait(500);

        // when connected, attach handler called on mouse event
        mouse.attachEvent(onMouseEvent);

        // wait until the mouse is disconnected
        while(mouse.connected())
            Thread::wait(500);
        printf("mouse seen disconnected\n");
    }
}
void onKey(uint8_t key) {
       
   // printf("%c\r", key);    
   
   if(index>=51)
   {
    
    
    printf(" Limit Exceeded \r\n   ");
    printf(" Please Re Enter \r\n  ");
    index=0;
    memset(Barcode,'\0',50);
    return;
    }
    if((key!=0x0A))
    { 
      Barcode[index]=key;
      index++;  
      //printf("%s \r\n",Barcode);
    }
    
    else if((key==0x0A) &&(index<=50))
    {
    Barcode[index]='\0';   
    printf("BARCODE  : %s \r\n",Barcode);
    memset(Barcode,'\0',50);
    index=0;
    }
    
    else if((key==0x0A) && (index>=51))
    {
   
    printf(" Too Many Charecters   : %s \r\n",Barcode);
    printf(" Invalid Barcode\r\n");
       
    }
    
}


void BarCodeReader_task(void const *) {
    
    USBHostKeyboard BarCodeReader;
    
    while(1) {
        // try to connect a USB keyboard
        while(!BarCodeReader.connect())
            Thread::wait(500);
        // when connected, attach handler called on keyboard event
        BarCodeReader.attach(onKey);
        // wait until the keyboard is disconnected
        while(BarCodeReader.connected())
            Thread::wait(500);
    }
}



void msd_task(void const *) {

    USBHostMSD msd;
    int i = 0;
    FATFileSystem fs("usb");
    int err;
    printf("wait for usb memory stick insertion\n");
    while(1) {

        // try to connect a MSD device
        while(!msd.connect()) {
            Thread::wait(500);
        }
        if (fs.mount(&msd) != 0) continue;
        else  
            printf("file system mounted\n");

        if  (!msd.connect()) {
            continue;
        }

        // in a loop, append a file
        // if the device is disconnected, we try to connect it again

        // append a file
        File file;
        err = file.open(&fs, "test1.txt", O_WRONLY | O_CREAT |O_APPEND);

        if (err == 0) {
            char tmp[100];
            sprintf(tmp,"Hello fun USB stick  World: %d!\r\n", i++);
            file.write(tmp,strlen(tmp));
            sprintf(tmp,"Goodbye World!\r\n");
            file.write(tmp,strlen(tmp));
            file.close();
        } else {
            printf("FILE == NULL\r\n");
        }
        Thread::wait(500);
        printf("again\n");
        // if device disconnected, try to connect again
        while (msd.connected()) {
            Thread::wait(500);
        }
        while (fs.unmount() < 0) {
            Thread::wait(500);
            printf("unmount\n"); 
        }
    }
}

int main() {
    
    memset(Barcode,'\0',20);
    Thread msdTask(msd_task, NULL, osPriorityNormal, 4096);
    Thread mouseTask(mouse_task, NULL, osPriorityNormal, 4096);
    Thread BarCodeTask(BarCodeReader_task, NULL, osPriorityNormal, 4096);
    
    while(1) {
        led=!led;
        Thread::wait(500);
    }
}