#include "mbed.h"

 #include "APSEPM207LV.h"
 
  Serial pc(USBTX, USBRX);
  APSEPM207LV tp(D1,D0); // tx, 9600bps
 
  int main()
  {
      tp.initialize();
      tp.putLineFeed(2);
 
      tp.printf("** Thermal Printer Shield **\r\r");
 
     
      tp.setKanjiFont(APSEPM207LV::KANJI_DEFAULT);
      tp.setANKFont(APSEPM207LV::ANK_DEFAULT);
     tp.setDoubleSizeWidth();
     tp.printf("ABCDEFG 0123456789\r");
     tp.clearDoubleSizeWidth();

     tp.setDoubleSizeHeight();
     tp.printf("ABCDEFG 0123456789\r");
     tp.clearDoubleSizeHeight();

     pc.printf("APS Thermal Printer\n\n");
     while(1) {
         if (pc.readable()) {
             int c = pc.getc();
             pc.putc(c);
             tp.putc(c);
         }
     }
  }
 