
// SPI Single IO NOR Flash Library for Nucleo F767ZI Interfacing



#include "mbed.h"
#include "S70FL01GS.h"
#include <string>

Serial pc(USBTX, USBRX); // tx, rx

int main()
{
    S70FL01GS flash(PA_7, PA_6, PA_5, PA_4);
    pc.printf("SPI init done\r\n\r\n");
    uint8_t buffer[100]= {0};
    // Read Identification information Related to chip.

    flash.Read_Identification(buffer);
    for(int i=0; i<80; i++) {
        printf(" ID is %X\r\n",buffer[i]);
    }

    wait(1);
    // Reading Flash Memory Status Register1 contents.

    uint8_t STATUS_REGISTER1= flash.readRegister();
    pc.printf(" STATUS REGISTER1 CONTENTS:%X\r\n\r\n",STATUS_REGISTER1);

    wait(1);

    flash.clearRegister();

    uint8_t Read_Value=flash.readRegister();
    pc.printf(" reading value here %s\r\n\n",Read_Value);

    STATUS_REGISTER1= flash.readRegister();
    pc.printf(" STATUS REGISTER1 CONTENTS:%X\r\n\r\n",STATUS_REGISTER1);
    wait(1);

    printf("Read_Value   : %X",Read_Value);

// write a stream of characters to arbitrary address 0x168
    char stri[] = "Shivanand Gowda Ramaiah";

    pc.printf("Writing String Here: %s\r\n",stri);


    flash.writeStream(0x00, stri, 22); //Writing Strings in three Differnt addresses.
    flash.writeStream(22, stri, 22);
    flash.writeStream(44, stri, 22);
    
//   
//    uint8_t a=flash.readRegister();
//    read stream from 0x168
    char str2[22] = {0};
    char str3[22] = {0};
    char str4[22] = {0};
    pc.printf("Before String Here: %s\r\n",str2);
    flash.readStream(0x00, str2, 22);
    pc.printf("After Read 1 String Here: %s\r\n",str2);
    flash.readStream(22, str4, 22);
    pc.printf("After Read 2 String Here: %s\r\n",str2);
    flash.readStream(44, str3, 22);
    pc.printf("After Read 3 String Here: %s\r\n",str2);
//
//    for(int i=0; i<20;i++)
//    pc.printf("Printing byte by byte %c\r\n",str2[i]);


    flash.sectorErase(0x00);
    while(1) {
        uint8_t busy=flash.checkIfBusy();
        if(busy==0) {
            pc.printf("Not  Busy any More \r\n");
            break;
        } else if (busy==1)
            pc.printf("Busy Now \r\n");
    }

    pc.printf("Exited from program  \r\n");
    return 0;

}
