// S2568FBLL.cpp

#include"S2568FBLL.h"

// CONSTRUCTOR
S2568FBLL::S2568FBLL(PinName mosi, PinName miso, PinName sclk, PinName cs,PinName hold) : SPI(mosi, miso, sclk), _cs(cs), _hold(hold)
{
    this->format(SPI_NBIT, SPI_MODE);
    this->frequency(SPI_FREQ);
    chipDisable();
    holdEnable();       // Keep Hold High Always.... for read write operations.
    // if you want to abort while transaction is happening use holdDiasable();
    // Read Data Sheet Before Using Hold Disable
    
}
// READING
int S2568FBLL::readByte(int addr)
{
    writeRegister(RWMODE_BYTE);
    chipEnable();
    this->write(READ);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    int response = this->write(DUMMY_ADDR);
    chipDisable();
    return response;
}

void S2568FBLL::readStream(int addr, char* buf, int count)
{
    if (count < 1)
        return;
    writeRegister(RWMODE_SEQ);
    chipEnable();
    this->write(READ);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    for (int i = 0; i < count; i++) {
        buf[i] =  this->write(DUMMY_ADDR);
        printf("i= %d   :%c \r\n",i,buf[i]);
    }
    chipDisable();
}

// WRITING
void S2568FBLL::writeByte(int addr, int data)
{
    writeRegister(RWMODE_BYTE);
    chipEnable();
    this->write(WRITE);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    this->write(data);
    chipDisable();
    // wait(WAIT_TIME);//instead of wait poll for WIP flag of status reg or use checkIfBusy() function...see main for more dtails 
}

void S2568FBLL::writeStream(int addr, char* buf, int count)
{
    if (count < 1)
        return;
    writeRegister(RWMODE_SEQ);
    chipEnable();
    this->write(WRITE);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    for (int i = 0; i < count; i++) {
        this->write(buf[i]);
    }
    wait(0.1);
    chipDisable();
    wait(WAIT_TIME);
}

void S2568FBLL::writeString(int addr, string str)
{
    if (str.length() < 1)
        return;
    writeRegister(RWMODE_SEQ);
    chipEnable();
    this->write(WRITE);
    this->write((addr & ADDR_BMASK3) >> ADDR_BSHIFT3);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    for (int i = 0; i < str.length(); i++)
        this->write(str.at(i));
    chipDisable();
    wait(WAIT_TIME);//instead of wait poll for WIP flag of status reg or use checkIfBusy() function...see main for more dtails 
}



uint8_t S2568FBLL::readRegister(void)
{
    chipEnable();
    this->write(RDMR);
    uint8_t val=this->write(DUMMY_ADDR);
    chipDisable();
   //wait(WAIT_TIME);//instead of wait poll for WIP flag of status reg or use checkIfBusy() function...see main for more dtails 
    //printf("value of reg is %X  \r\n",val);
    return(val);

}



void S2568FBLL::writeRegister(uint8_t regValue)
{
   
    chipEnable();
    this->write(WRMR);
    this->write(regValue);
    chipDisable();
  
   // wait(WAIT_TIME);            //instead of wait poll for WIP flag of status reg or use checkIfBusy() function...see main for more dtails 
}




void S2568FBLL::writeLong(int addr, long value)
{
    //Decomposition from a long to 4 bytes by using bitshift.
    //One = Most significant -> Four = Least significant byte
    uint8_t four = (value & 0xFF);
    uint8_t three = ((value >> 8) & 0xFF);
    uint8_t two = ((value >> 16) & 0xFF);
    uint8_t one = ((value >> 24) & 0xFF);

    writeRegister(RWMODE_SEQ);
    chipEnable();
    this->write(WRITE);
 
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    this->write(four);
    this->write(three);
    this->write(two);
    this->write(one);
    chipDisable();
    wait(0.1);
}

long S2568FBLL::raedLong(int addr)
{
    //Read the 4 bytes from the eeprom memory.
   writeRegister(RWMODE_SEQ);
    chipEnable();
    this->write(READ);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);

    long four = this->write(DUMMY_ADDR);
    long three = this->write(DUMMY_ADDR);
    long two = this->write(DUMMY_ADDR);
    long one = this->write(DUMMY_ADDR);
    chipDisable();
    //Return the recomposed long by using bitshift.
    return ((four << 0) & 0xFF) + ((three << 8) & 0xFFFF) + ((two << 16) & 0xFFFFFF) + ((one << 24) & 0xFFFFFFFF);
   
}


//ENABLE/DISABLE (private functions)

void S2568FBLL::chipEnable()
{
    _cs = 0;
}
void S2568FBLL::chipDisable()
{
    _cs = 1;
}

void S2568FBLL::holdEnable()
{
    _hold = 1;
}

void S2568FBLL::holdDisable()
{
    _hold = 0;
}