// S2568FBLL.h

//Instruction Name Instruction Format           Hex
//Code                Description
//READ                  0000 0011               0x03            Read data from memory array beginning at selected address
//WRITE                 0000 0010               0x02            Write data to memory array beginning at selected address
//ESDI                  0011 1011               0x3B            Enter SDI mode
//ESQI                  0011 1000               0x38            Enter SQI mode
//RSTDQI                1111 1111               0xFF            Reset SDI/SQI mode
//RDMR                  0000 0101               0x05            Read Mode Register
//WRMR                  0000 0001               0x01            Write Mode Register

#ifndef S2568FBLL_H
#define S2568FBLL_H

#include "mbed.h"
#include <string>

#define SPI_FREQ        5000000                 //Change SPI Frequency Here
#define SPI_MODE        0                       // SPI Mode can be 0 or 3 . see data sheet
#define SPI_NBIT        8                       // Number of bits 8.



#define DUMMY_ADDR      0x00
#define WAIT_TIME       1

#define ADDR_BMASK3     0xff000000
#define ADDR_BMASK2     0x00ff0000
#define ADDR_BMASK1     0x0000ff00
#define ADDR_BMASK0     0x000000ff

#define ADDR_BSHIFT3    24
#define ADDR_BSHIFT2    16
#define ADDR_BSHIFT1    8
#define ADDR_BSHIFT0    0

#define READ            0x03           // Read data from memory array beginning at selected address
#define WRITE           0x02           //Write data to memory array beginning at selected address
#define ESDI            0x3B           //Enter SDI mode
#define ESQI            0x38           //Enter SQI mode
#define RSTDQI          0xFF           //Reset SDI/SQI mode
#define RDMR            0x05           //Read Mode Register
#define WRMR            0x01           //Write Mode Register

#define RWMODE_BYTE      0x00              //7th bit=0 and 6th bit =0 Byte mode  5 TO 0 BITS ARE RESERVED FOR FUTURE
#define RWMODE_PAGE      0x80              //        1              0 Page mode
#define RWMODE_SEQ       0x40              //        0              1= Sequential mode (default operation)

       

class S2568FBLL: public SPI {
public:
    S2568FBLL(PinName mosi, PinName miso, PinName sclk, PinName cs,PinName hold);
    
    int readByte(int addr);                                 // takes a 24-bit (3 bytes) address and returns the data (1 byte) at that location                   
    void readStream(int addr, char* buf, int count);        // takes a 24-bit address, reads count bytes, and stores results in buf
    void writeByte(int addr, int data);                     // takes a 24-bit (3 bytes) address and a byte of data to write at that location
    void writeStream(int addr, char* buf, int count);       // write count bytes of data from buf to memory, starting at addr  
    void writeString(int add, string str);
    long raedLong(int addr);
    void writeLong(int addr, long value);
    uint8_t readRegister(void);                                                       // Write Long Integer Number
private:
 
    void writeRegister(uint8_t regValue);
    void chipEnable();                                      // chip enable
    void chipDisable();  
    void holdEnable();
    void holdDisable();
                                                     // chip disable
    
   // SPI _spi;
    DigitalOut _cs;
    DigitalOut _hold;
};

#endif