

#include "mbed.h"
#include "MFRC522.h"
#include <string>

using namespace std;
// Nucleo Pin for MFRC522 reset (pick another D pin if you need D8)
DigitalOut LedGreen(LED1);

//Serial connection to PC for output
Serial pc(SERIAL_TX, SERIAL_RX);

MFRC522    mfrc522   (PA_7, PA_6, PA_5, PD_14, PD_15);

void getHexa(char checkSum, char *str)
{
    char strtemp[3];
    memset(strtemp, 0x00, sizeof(strtemp));
    sprintf(strtemp, "%02X", checkSum);
    memcpy(str, strtemp, 2);
    return;
}

int  main(void)
{
    pc.printf("starting...\n");
    mfrc522.PCD_Init();
    MFRC522::MIFARE_Key key;
   
    bool New_Card=false,Read_Card=false;
     uint8_t rettype;
    char buffer[34]="exultsoft";
    uint8_t block;
    uint8_t status;
    uint8_t len;
    uint8_t data[34]={0};
    
    for (uint8_t i = 0; i < 6; i++) key.keyByte[i] = 0xFF;
    LedGreen = 1;
    // Look for new cards
    if (  mfrc522.PICC_IsNewCardPresent()) {
        wait_ms(50);
        New_Card=true;
        //continue;
    }
    // Select one of the cards
    if (  mfrc522.PICC_ReadCardSerial()) {
        // pc.printf("Rien");
        wait_ms(50);
        Read_Card=true;
    }
    LedGreen = 0;
    if(Read_Card==true && New_Card==true) {
        char CARD_UID[9]= {'\0'};
        char str1[3],str2[3],str3[3],str4[3];
        getHexa(mfrc522.uid.uidByte[0], str1);
        getHexa(mfrc522.uid.uidByte[1], str2);
        getHexa(mfrc522.uid.uidByte[2], str3);
        getHexa(mfrc522.uid.uidByte[3], str4);

        CARD_UID[0]=str1[0];
        CARD_UID[1]=str1[1];
        CARD_UID[2]=str2[0];
        CARD_UID[3]=str2[1];
        CARD_UID[4]=str3[0];
        CARD_UID[5]=str3[1];
        CARD_UID[6]=str4[0];
        CARD_UID[7]=str4[1];
        CARD_UID[8]='\0';
        printf("CARD_UID  New :   %s\r\n",CARD_UID);
        Read_Card=false;
        New_Card=false;
    }



    printf(" PICC type: ");   // Dump PICC type
    rettype = mfrc522.PICC_GetType(mfrc522.uid.sak);
    printf("%s\r\n",mfrc522.PICC_GetTypeName(rettype));
    
   
    for (int index=0; index<34;index++)
    {
        data[index]=(uint8_t)buffer[index];
    }
    
    block = 9;
    printf("Authenticating using key A...");
    status = mfrc522.PCD_Authenticate(MFRC522::PICC_CMD_MF_AUTH_KEY_A, block, &key, &(mfrc522.uid));
    if (status != MFRC522::STATUS_OK) {
        printf("PCD_Authenticate() failed:\r\n ");
        printf("%s\r\n",mfrc522.GetStatusCodeName(status));
        return;
    } else printf("PCD_Authenticate() success\r\n ");


    // Write block
    status = mfrc522.MIFARE_Write(block, data, 16);
    if (status != MFRC522::STATUS_OK) {
        printf("MIFARE_Write() failed: ");
        printf("%s",mfrc522.GetStatusCodeName(status));
        return;
    }
    else printf("MIFARE_Write() success\r\n ");
    
    
    
  uint8_t buffer1[18];

  block = 9;
  len = 18;
 
  status = mfrc522.PCD_Authenticate(MFRC522::PICC_CMD_MF_AUTH_KEY_A, 4, &key, &(mfrc522.uid)); //line 834 of MFRC522.cpp file
  if (status != MFRC522::STATUS_OK) {
     printf("Authentication failed: ");
    printf("%s\r\n",mfrc522.GetStatusCodeName(status));
    return;
  }

  status = mfrc522.MIFARE_Read(block, buffer1, &len);
  if (status != MFRC522::STATUS_OK) {
    printf("Reading failed: ");
   printf("%s",mfrc522.GetStatusCodeName(status));
    return;
  }

  //PRINT FIRST NAME
  for (uint8_t i = 0; i < 16; i++)
  {
    if (buffer1[i] != 32)
    {
     printf("%c",buffer1[i]);
    }
  }
   printf("\r\n");

}