/* @file HelloKeypad.cpp
|| @version 1.1
|| @modified by Diego (http://hotboards.org)
|| @author Alexander Brevig
|| @contact alexanderbrevig@gmail.com
||
|| @description
|| | Demonstrates the simplest use of the matrix Keypad library.
|| | Just press any key an it will be displayed on the serial port
|| #
*/
#include "mbed.h"
#include "Hotboards_keypad.h"

// Defines the keys array with it's respective number of rows & cols,
// and with the value of each key
char keys[ 7 ][ 7 ] =
{
    { '1' , '2' , '3' , '4', '5', '6' ,'a'},
    { '7' , '8' , '9' , '0', 'Q', 'W' ,'b'},
    { 'E' , 'R' , 'T' , 'Y', 'U', 'I' ,'c'},
    { 'O' , 'P' , 'A' , 'S', 'D', 'F' ,'d'},
    { 'G' , 'H' , 'J' , 'K', 'L', 'Z' ,'e'},
    { 'X' , 'C' , 'V' , 'B', 'N', 'M' ,'f'},
    { 0x0D , 0x20 , 0x08 , 'g','h','i','j'},     //0x0D -> Enter Key , 0x20 -> Space, 0x08-> Backspace, a , b, c may be used as functions keys.    
};

// Defines the pins connected to the rows
DigitalInOut rowPins[ 7 ] = { D0,D1,D2,D3,D4,D5,D6};
// Defines the pins connected to the cols
DigitalInOut colPins[ 7 ] = { D7,D8,D9,D10,D11,D12,D13};

// Creates a new keyboard with the values entered before
Keypad kpd( makeKeymap( keys ) , rowPins , colPins , 7 , 7 );

// Configures the serial port
Serial pc( USBTX , USBRX );

int main()
{
    pc.printf( "Press any key: " );
    while(1)
    {
        // Poll the keypad to look for any activation
        char key = kpd.waitForKey();
        
        // If any key was pressed
        if( key )
        {
            // Display the key pressed on serial port
            pc.printf( "Pressed key is   : %c" , key );
            pc.printf( "\n\r" );
        }
    }
}
