#include "mbed.h"
 #include "NextionLCD.h"
 #include "Time.h"
 #define  PASSWORD 11111
 
#include "MFRC522.h"
#include "Card.h"
 
RawSerial pc(USBTX,USBRX);
NextionLCD lcd(D1, D0);     //Tx, Rx
Thread Menu;
Thread DispTime;
Thread DispName;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut relay(D8);


volatile char c;
uint8_t Present_State=0;
uint8_t Previous_State=0;
uint8_t Back=0;
void Page1(void);
void Page2(void);
void Page3(void);
void Page4(void);
void Main_Menu(void);
void flip(void);

 
 char prevPage='\0';
//bool flag=true;
char Cand_Name[25]={'\0'};
 char Time_Disp[30]={'\0'};
 
 void Display_Details(void);
 
void pc_recv()
{      
    while(pc.readable()) 
    {
      c=pc.getc();    
    }
}


void Menu_Selection()
{  
   
    while(1)
    {
             pc_recv();  
        switch (c)
        {
       case '1':  
                    Main_Menu();
                    c='\0';
                    wait(1);
               break;
               
       case '2':
                Page1();
                c='\0';
                wait(1);
              break;
                
       case '3':
                Page2();
                c='\0';
                wait(1);
             break;
       case '4':
                Page3();
                c='\0';
                wait(1);
               break;
               
       case '5': 
                Page4();
                c='\0';
                wait(1);
               break;  
       default: 
                    //lcd.DrawString(0,0,480,40,2,WHITE,BLACK,0,2, "Flash Master Card to Edit");      
//                    Display_Details();
                    wait(1);
                break;  
        }
    }   
}

void Display_Time(void)
{
  while(true)
  {
    Get_Date_Time_Display(Time_Disp);
    lcd.DrawString(0,0,480,40,2,BLACK,WHITE,0,0,Time_Disp); 
    lcd.DrawString(0,295,480,25,1,BLACK,WHITE,0,0,"Powered by Exultsoft Technolies Pvt. Ltd.");
    wait(60);
    memset(Time_Disp,'\0',30);
  }
 
}
 int main() 
 {    
      char CARDNO[30]={'\0'};
      lcd.ClrScr(BLACK);      
      lcd.DrawString(0,100,480,40,2,WHITE,BLACK,0,2,  "##############################"); 
      lcd.DrawString(0,150,480,40,2,YELLOW,BLACK,0,0, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
      lcd.DrawString(0,200,480,40,2,BLUE,BLACK,0,0,   "------------------------------");
      lcd.ClrScr(BLACK);
      wait(10); 
      iSetTerminalTime("27072018111213");
      Menu.start(callback(Menu_Selection));
      DispTime.start(callback(Display_Time));
      DispName.start(callback(Display_Details));  
     
      int success=-1;
      while(true)
      {
      MIFARE_Init();
      Read_Card_Details(CARDNO);
      
     success= strcmp(CARDNO,"17D6C66B");
         if(success==0)
         {
         flip();
         wait(1);
         }
      }
 }




void Main_Menu(void)
{   
      lcd.DrawString(0,40,480,40,2,WHITE,BLACK,0,0, "1. MAIN MENU "); 
      lcd.DrawString(0,80,480,40,2,YELLOW,RED,0,0,"2. OPTION ONE  ");
      lcd.DrawString(0,120,480,40,2,BLUE,GREEN,0,0, "3. OPTION TWO ");
      lcd.DrawString(0,160,480,40,2,BROWN,WHITE,0,0,"4. OPTION THREE ");
      lcd.DrawString(0,200,480,40,2,RED,YELLOW,0,0,  "5. OPTION FOUR ");
      lcd.DrawString(0,240,480,40,2,GREEN,BLUE,0,0,"6. OPTION FIVE");
      wait(1);
      Present_State=1; Previous_State=0;
}

void Page1(void)
{   
      lcd.DrawString(0,40,480,40,2,WHITE,BLACK,0,2,   "1. MAIN MENU "); 
      lcd.DrawString(0,80,480,40,2,YELLOW,RED,0,0,  "2. PAGE 1  OPTION ONE  ");
      lcd.DrawString(0,120,480,40,2,BLUE,GREEN,0,0, "3. PAGE 1  OPTION TWO ");
      lcd.DrawString(0,160,480,40,2,WHITE,GRAY,0,0, "4. PAGE 1  OPTION THREE ");
      lcd.DrawString(0,200,480,40,2,RED,YELLOW,0,0, "5. PAGE 1  OPTION FOUR ");
      lcd.DrawString(0,240,480,40,2,GREEN,BLUE,0,0, "6. PAGE 1  OPTION FIVE");
      wait(1);
      Present_State=2; Previous_State=0;
}

void Page2(void)
{   
      lcd.DrawString(0,40,480,40,2,WHITE,BLACK,0,2,   "1. MAIN MENU "); 
      lcd.DrawString(0,80,480,40,2,YELLOW,RED,0,0,  "2. PAGE 2  OPTION ONE  ");
      lcd.DrawString(0,120,480,40,2,BLUE,GREEN,0,0, "3. PAGE 2  OPTION TWO ");
      lcd.DrawString(0,160,480,40,2,WHITE,GRAY,0,0, "4. PAGE 2  OPTION THREE ");
      lcd.DrawString(0,200,480,40,2,RED,YELLOW,0,0, "5. PAGE 2  OPTION FOUR ");
      lcd.DrawString(0,240,480,40,2,GREEN,BLUE,0,0, "6. PAGE 2  OPTION FIVE");
      wait(1);
      Present_State=3; Previous_State=0;
}

void Page3(void)
{   
      lcd.DrawString(0,40,480,40,2,WHITE,BLACK,0,2,   "1. MAIN MENU "); 
      lcd.DrawString(0,80,480,40,2,YELLOW,RED,0,0,  "2. PAGE 3  OPTION ONE  ");
      lcd.DrawString(0,120,480,40,2,BLUE,GREEN,0,0, "3. PAGE 3  OPTION TWO ");
      lcd.DrawString(0,160,480,40,2,WHITE,GRAY,0,0, "4. PAGE 3  OPTION THREE ");
      lcd.DrawString(0,200,480,40,2,RED,YELLOW,0,0, "5. PAGE 3  OPTION FOUR ");
      lcd.DrawString(0,240,480,40,2,GREEN,BLUE,0,0, "6. PAGE 3  OPTION FIVE");
      wait(1); 
  
Present_State=4; Previous_State=0; 
}

void Page4(void)
{   
       lcd.DrawString(0,40,480,40,2,WHITE,BLACK,0,2,   "1. MAIN MENU "); 
      lcd.DrawString(0,80,480,40,2,YELLOW,RED,0,0,  "2. PAGE 4  OPTION ONE  ");
      lcd.DrawString(0,120,480,40,2,BLUE,GREEN,0,0, "3. PAGE 4  OPTION TWO ");
      lcd.DrawString(0,160,480,40,2,WHITE,GRAY,0,0, "4. PAGE 4  OPTION THREE ");
      lcd.DrawString(0,200,480,40,2,RED,YELLOW,0,0, "5. PAGE 4  OPTION FOUR ");
      lcd.DrawString(0,240,480,40,2,GREEN,BLUE,0,0, "6. PAGE 4  OPTION FIVE");
      wait(1);
      Present_State=0; Previous_State=0;
}

void Display_Details(void)
{    
   while(1)
   { 
     Thread::signal_wait(0x2);
     memcpy(Cand_Name,"        Good Morning",20);
     int hours=Get_Hours();
     if(hours>=0 && hours <12) 
     lcd.FillRectangle(0,40,480,255,BLUE);
     lcd.DrawString(0,40,480,40,2,WHITE,BLUE,0,2,Cand_Name); 
     lcd.DrawString(0,80,480,40,2,WHITE,BLUE,0,2,"Name of CARD Holder");  
     lcd.DrawString(0,120,480,40,2,WHITE,BLUE,0,2,"     Have a Great Day ");  
     memset(Cand_Name,'\0',25);
     relay=0;  
     wait(1);
     relay=1;
     wait(2);
     lcd.FillRectangle(0,40,480,255,BLUE);
     
     }
}


void flip(void)
{
   led1=!led1;
   led2=!led2;
   led3=!led3;
   DispName.signal_set(0x02); 
  
}

