
#include "MFRC522.h"
#include "Card.h"

#define     MIFARE_MOSI                 PA_7
#define     MIFARE_MISO                 PA_6
#define     MIFARE_SCLK                 PA_5
#define     MIFARE_CS                   PA_4
#define     MIFARE_RESET                PB_4

MFRC522    mfrc522(MIFARE_MOSI,MIFARE_MISO,MIFARE_SCLK,MIFARE_CS,MIFARE_RESET);
//MFRC522    mfrc522 (PA_7, PA_6, PA_5, PD_14, PD_15);

bool New_Card=false,Read_Card=false;

extern char  CARD_UID= {'\0'};
MFRC522::MIFARE_Key key;
void MIFARE_Init(void)

{
    mfrc522.PCD_Init();

}



void Read_Card_Details(char *CARD_UID)
{
    memset(CARD_UID,'\0',9);
    for (uint8_t i = 0; i < 6; i++)
        key.keyByte[i] = 0xFF;
  
    // Look for new cards
    
    if (  mfrc522.PICC_IsNewCardPresent()) {
         wait_ms(50);
            New_Card=true;
    }
    
    // Select one of the cards
    
    if (  mfrc522.PICC_ReadCardSerial()) {
       
         wait_ms(50);
        Read_Card=true;
    }

   
    if(Read_Card==true && New_Card==true) {
        char str1[3],str2[3],str3[3],str4[3];
        getHexa(mfrc522.uid.uidByte[0], str1);
        getHexa(mfrc522.uid.uidByte[1], str2);
        getHexa(mfrc522.uid.uidByte[2], str3);
        getHexa(mfrc522.uid.uidByte[3], str4);
        CARD_UID[0]=str4[0];
        CARD_UID[1]=str4[1];
        CARD_UID[2]=str3[0];
        CARD_UID[3]=str3[1];
        CARD_UID[4]=str2[0];
        CARD_UID[5]=str2[1];
        CARD_UID[6]=str1[0];
        CARD_UID[7]=str1[1];
        CARD_UID[8]='\0';
        printf("CARD_UID :   %s\r\n",CARD_UID);
        Read_Card=false;
        New_Card=false;
    }
}

void getHexa(char checkSum, char *str)
{
    char strtemp[3];

    memset(strtemp, 0x00, sizeof(strtemp));
    sprintf(strtemp, "%02X", checkSum);
    memcpy(str, strtemp, 2);

    return;
}

