
//  Include --------------------------------------------------------------------
#include "mbed.h"
#include "7segLed_HC595.h"
#include "RS485.h"

//  Definition -----------------------------------------------------------------
#define NUM_OF_DIGIT    6
#define KEYIN_THEN_EXIT_WHILE() {if(exit_while_loop_when_keyinput()){ break;}}

SevenSegLed led_7segs(PC_12,PC_10, PC_9, PC_8,  NUM_OF_DIGIT);
// Serial_Data_Out, Serial_Clock, Latch , PWM_Brightness_Contol
Serial pc(USBTX,USBRX);
Serial rs485(PF_7,PF_6,PA_1);
DigitalOut  myled(LED1);
AnalogIn    vol(A0);
time_t seconds;

DigitalIn sw1(PE_10);
DigitalIn sw2(PE_12);
DigitalIn sw3(PE_13);
DigitalIn sw4(PE_14);
DigitalIn sw5(PH_1);
DigitalIn sw6(PH_0);
DigitalIn sw7(PC_15);
DigitalIn sw8(PC_14);

char Rx_Data[20]={'\0'};
char Floor_No_MSB,Floor_No_LSB;
int Get_Floor_Number( int result);
int validate_rx_data(char *Rx);
int read_switch_state(void);
int Count=0;
bool exit_while_loop_when_keyinput(void);


int main()
{
        int value=read_switch_state();
        int floor=Get_Floor_Number(value);
        
        uint32_t max = 4;
        for (uint32_t i = 1; i < NUM_OF_DIGIT; i++) 
        {
            max = max * 10 + 9;
        }
        pc.printf("max = %d\r\n", max);
        led_7segs.zero_suppress(true);
        
        
        while(true)
        { 
            if(rs485.readable())
            {
               int i=0;
              //A22010055B; Send this data to Mbed Device through RS485
              // A - Start of Frame 
              // 22 - Display Address Panel Number 
              // 0 - Delimeter 
              // 1- Turn On Display
              //0- Delimiter
              //055 or xxx Number to be displayed 
              // B; End of Frame.       
               Rx_Data[i++]=rs485.getc();    
            }
                     
         }       
}



int validate_rx_data(char *Rx)
{
   int res;
   if( Rx[0]=='A' && Rx[1]=='2'&& Rx[2]=='2'
    && Rx[3]==0x30 && Rx[4]=='1'&& Rx[5]==0x30
    && Rx[9]=='B')
    {
      printf("Valid Data Recieved \r\n");  
        int a =Rx[6]-0x30;
        int b=Rx[7]-0x30;
        int c=Rx[8]-0x30;
         res=(a<<16 ||b<<8||c);
        led_7segs=res;
        return 1;
    }
    
    else if( Rx[0]=='A' && Rx[1]=='2'&& Rx[2]=='2'
    && Rx[3]==0x30 && Rx[4]=='2'&& Rx[5]==0x30
    && Rx[9]=='B')
    {
        char str[4]="nil";
        printf("Valid Data Recieved \r\n");   
        led_7segs=res;
        led_7segs.put_strings(str);
        return 1;
    }
    else 
    {
        printf(" Not Intended to me \r\n");
        memset(Rx,'\0',20); 
        return 0;
    } 
    
}

int read_switch_state(void)
{
    int c1,c2,c3,c4,c5,c6,c7,c8; int res=0;
    if(sw1==0)
       c1=0;  
    else 
    c1=1; 
    if(sw2==0)
       c2=0;   
    else
    c2=0x02; 
    if(sw3==0)
     c3=0;  
    else
    c3=0x04; 
    if(sw4==0)
       c4=0;   
    else
    c4=0x08; 
    
    if(sw5==0)
       c5=0;  
    else 
    c5=16; 
    if(sw6==0)
       c6=0;   
    else
    c6=32; 
    if(sw7==0)
     c7=0;  
    else
    c7=64; 
    if(sw8==0)
       c8=0;   
    else
    c8=128; 
    
    res=c1|c2|c3|c4|c5|c6|c7|c8;
    if(res==1)
    return 1;
    else if(res==3)
    return 2;
    else if(res==7)
    return 3;
    else if(res==15)
    return 4;
    else if(res==31)
    return 5;
    else if(res==63)
    return 6;
    else if(res==127)
    return 7;  
    else if(res==255)
    return 8;   
    
    return -1;
}


int Get_Floor_Number( int result )
{   
    int MSB;int LSB;
    MSB=0x30;
    LSB=0x30+result;
    result=MSB+LSB;
    return result;
    
}