// M95M02D.h

#ifndef M95M02D_H
#define M95M02D_H

#include "mbed.h"
#include <string>

#define SPI_FREQ        5000000                 //Change SPI Frequency Here
#define SPI_MODE        0                       // SPI Mode can be 0 or 3 . see data sheet
#define SPI_NBIT        8                       // Number of bits 8.



#define DUMMY_ADDR      0x00
#define WAIT_TIME       1

#define ADDR_BMASK3     0xff000000
#define ADDR_BMASK2     0x00ff0000
#define ADDR_BMASK1     0x0000ff00
#define ADDR_BMASK0     0x000000ff

#define ADDR_BSHIFT3    24
#define ADDR_BSHIFT2    16
#define ADDR_BSHIFT1    8
#define ADDR_BSHIFT0    0


#define     READ            0x03        //0000 0011 Read data from memory array beginning at selected address
#define     WRITE           0x02        //0000 0010 Write data to memory array beginning at selected address
#define     WREN            0x06        //0000 0110 Set the write enable latch (enable write operations)
#define     WRDI            0x04        //0000 0100 Reset the write enable latch (disable write operations)
#define     RDSR            0x05        //0000 0101 Read STATUS register
#define     WRSR            0x01        //0000 0001 Write STATUS register
#define     PE              0x42        //0100 0010 Page Erase – erase one page in memory array
#define     SE              0xD8        //1101 1000 Sector Erase – erase one sector in memory array
#define     CE              0xC7        //1100 0111 Chip Erase – erase all sectors in memory array
#define     ReadID          0x83        //1000 0011 Read id or  electronic signature
#define     WriteID         0x82        //1000 0011 Write id or  electronic signature

#define     DUMMYBYTE       0x00        //Dummy byte for Read Operation

class M95M02D: public SPI {
public:
    M95M02D(PinName mosi, PinName miso, PinName sclk, PinName cs,PinName WP,PinName HOLD);
    
  
    
    
    int readByte(int addr);                                 // takes a 24-bit (3 bytes) address and returns the data (1 byte) at that location                   
    void readStream(int addr, char* buf, int count);        // takes a 24-bit address, reads count bytes, and stores results in buf
    int  ReadSignature(void);
    void writeByte(int addr, int data);                     // takes a 24-bit (3 bytes) address and a byte of data to write at that location
    void writeStream(int addr, char* buf, int count);       // write count bytes of data from buf to memory, starting at addr  
    void writeString(int add, string str);
    void writePage(int pageNo,char *buf,int count);
                                      //erase all data on chip
    uint8_t readRegister();  
    uint8_t checkIfBusy();                                  // Check if IC is bury writing or erasing 
    void writeRegister(uint8_t regValue);                   // Write status register or configuration register                                   
    long readLong(int address);                             // Read long int number
    void writeLong(int addr, long value);                   // Write Long Integer Number
private:
    void writeEnable();                                     // write enable
    void writeDisable();                                    // write disable
    void chipEnable();                                      // chip enable
    void chipDisable();                                     // chip disable
    void EnableWriteProtect();
    void DisableWriteProtect();
    void Hold_ReadWrite();
    void ReleaseHold_ReadWrite();

    
   // SPI _spi;
    DigitalOut _cs;
    DigitalOut _wp;
    DigitalOut _hold;
    
};

#endif