// M95M02D.cpp
#include "mbed.h"
#include"M95M02D.h"

// CONSTRUCTOR
M95M02D::M95M02D(PinName mosi, PinName miso, PinName sclk, PinName cs, PinName WP, PinName HOLD) : SPI(mosi, miso, sclk), _cs(cs),_wp(WP),_hold(HOLD)
{
    this->format(SPI_NBIT, SPI_MODE);
    this->frequency(SPI_FREQ);
    chipDisable();

}
// READING


    
  int M95M02D::ReadSignature(void)
{ 
    chipEnable();
    this->write(ReadID);
    this->write(DUMMY_ADDR);
    this->write(DUMMY_ADDR);
    this->write(DUMMY_ADDR);
     int response = this->write(DUMMY_ADDR);
    chipDisable(); 
    return response; 
}  
    
    
int M95M02D::readByte(int addr)
{
    chipEnable();
    this->write(READ);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    int response = this->write(DUMMY_ADDR);
    chipDisable();
    return response;
}

void M95M02D::readStream(int addr, char* buf, int count)
{
    if (count < 1)
        return;
    chipEnable();
    this->write(READ);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    for (int i = 0; i < count; i++) {
        buf[i] =  this->write(DUMMY_ADDR);
       // printf("i= %d   :%c \r\n",i,buf[i]);
    }
    chipDisable();
  //  wait_ms(2);
}

// WRITING
void M95M02D::writeByte(int addr, int data)
{
    writeEnable();
    chipEnable();
    this->write(WRITE);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    this->write(data);
    chipDisable();
    writeDisable();
   wait_ms(2);
   uint8_t busy= checkIfBusy(); 
   while(busy==1)
   {
       //printf("Busy   :%d\r\n",busy);
       wait_ms(1);
       busy= checkIfBusy();
    }
    // wait(WAIT_TIME);//instead of wait poll for WIP flag of status reg or use checkIfBusy() function...see main for more dtails 
}

void M95M02D::writeStream(int addr, char* buf, int count)
{

    if (count < 1)
        return;
        
    writeEnable();    
    chipEnable();
    this->write(WRITE);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    for (int i = 0; i < count; i++) {
        this->write(buf[i]);
    }
    chipDisable();
    writeDisable();
     wait_ms(2);
   uint8_t busy= checkIfBusy(); 
   while(busy==1)
   {
       //printf("Busy   :%d\r\n",busy);
       wait_ms(1);
       busy= checkIfBusy();
    }
    }

void M95M02D::writeString(int addr, string str)
{
    if (str.length() < 1)
        return;
    writeEnable();
    chipEnable();
    this->write(WRITE);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    for (int i = 0; i < str.length(); i++)
        this->write(str.at(i));
    chipDisable();
    writeDisable();
    wait_ms(6);//instead of wait poll for WIP flag of status reg or use checkIfBusy() function...see main for more dtails 
}

void M95M02D::writePage(int pageNo,char *buf,int count)
{
 int addr=0;
 if(count >256)
 {
  printf("Cannot WRITE MORE THAN 256 BYTES Maximum Page Size is 256 bytes \r\n");  
  return;
 }
 else if(count <1)
 {
    printf("No data to Write \r\n"); 
    return;
 }
 
    addr=pageNo*256;     
    writeEnable();    
    chipEnable();
    this->write(WRITE);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    for (int i = 0; i < count; i++) {
        this->write(buf[i]);
    }
    chipDisable();
    writeDisable();
     wait_ms(2);
   uint8_t busy= checkIfBusy(); 
   while(busy==1)
   {
       //printf("Busy   :%d\r\n",busy);
       wait_ms(1);
       busy= checkIfBusy();
    }
    
    
}

uint8_t M95M02D::readRegister()
{

    chipEnable();
    this->write(RDSR);
    uint8_t val=this->write(DUMMY_ADDR);
    chipDisable();
   //wait(WAIT_TIME);//instead of wait poll for WIP flag of status reg or use checkIfBusy() function...see main for more dtails 
   //printf("value of reg is %X  \r\n",val);
    return(val);
}
//ERASING

uint8_t M95M02D::checkIfBusy()
{
    uint8_t value=readRegister();
   // printf("\r\n Value of Status Reg=%X\r\n\r\n",value);
    if((value & 0x01)==0x01 )
    {
        wait_ms(1);
        return 1;
        }
    else
    {
        wait_ms(1);
        return 0;
        }
}

void M95M02D::writeRegister(uint8_t regValue)
{
    writeEnable();
    chipEnable();
    this->write(WRSR);
    this->write(regValue);
    chipDisable();
    writeDisable();
    wait(WAIT_TIME);//instead of wait poll for WIP flag of status reg or use checkIfBusy() function...see main for more dtails 

}


void M95M02D::writeLong(int addr, long value)
{
    //Decomposition from a long to 4 bytes by using bitshift.
    //One = Most significant -> Four = Least significant byte
    uint8_t four = (value & 0xFF);
    uint8_t three = ((value >> 8) & 0xFF);
    uint8_t two = ((value >> 16) & 0xFF);
    uint8_t one = ((value >> 24) & 0xFF);

    writeEnable();
    chipEnable();
    this->write(WRITE);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    this->write(four);
    this->write(three);
    this->write(two);
    this->write(one);
    chipDisable();
    writeDisable();
    wait_ms(6);
}

long M95M02D::readLong(int addr)
{
    //Read the 4 bytes from the eeprom memory.
    chipEnable();
    this->write(READ);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);

    long four = this->write(DUMMY_ADDR);
    long three = this->write(DUMMY_ADDR);
    long two = this->write(DUMMY_ADDR);
    long one = this->write(DUMMY_ADDR);
    chipDisable();
    //Return the recomposed long by using bitshift.
    return ((four << 0) & 0xFF) + ((three << 8) & 0xFFFF) + ((two << 16) & 0xFFFFFF) + ((one << 24) & 0xFFFFFFFF);
    
}


//ENABLE/DISABLE (private functions)
void M95M02D::writeEnable()
{
    chipEnable();
    this->write(WREN);
    chipDisable();
}
void M95M02D::writeDisable()
{
    chipEnable();
    this->write(WRDI);
    chipDisable();
}
void M95M02D::chipEnable()
{
    _cs = 0;
}
void M95M02D::chipDisable()
{
    _cs = 1;
}

void M95M02D::EnableWriteProtect()
{
    _wp = 0;
}
void M95M02D::DisableWriteProtect()
{
    _wp = 1;
}

void M95M02D::Hold_ReadWrite()
{
    _hold = 0;
}
void M95M02D::ReleaseHold_ReadWrite()
{
    _hold = 1;
}
