
#include "mbed.h"
#include <string>
#include "eeprom.h"
#include "i2ceeprom.h"

#define EEPROM_ADDR 0x0   // I2c EEPROM address is 0x00

#define SDA D14           // I2C SDA pin
#define SCL D15           // I2C SCL pin

#define MIN(X,Y) ((X) < (Y) ? (X) : (Y))
#define MAX(X,Y) ((X) > (Y) ? (X) : (Y))

#define MB_ID 0x00
#define NO_OF_DEV 0x01
#define DEV_1_ID 0x02
#define DEV_1_ST 0x03
#define DEV_1_VAL 0x04
#define DEV_2_ID 0x05
#define DEV_2_ST 0x06
#define DEV_2_VAL 0x07
#define DEV_3_ID 0x08
#define DEV_3_VAL 0x09
#define DEV_4_ID 0x0A
#define DEV_4_ST 0x0B
#define DEV_4_VAL 0x0C

int mb_ID = 0x00;
int NOno_of_dev = 0x00;
int dev_1_id = 0x00;
int dev_1_st = 0x00;
int dev_1_val = 0x00;
int dev_2_id = 0x00;
int dev_2_st = 0x00;
int dev_2_val = 0x00;
int dev_3_id = 0x00;
int dev_3_st = 0x00;
int dev_3_val = 0x00;
int dev_4_id = 0x00;
int dev_5_st = 0x00;
int dev_6_val = 0x00;

extern float G_time;
extern float Y_time;
extern float R_time;


int32_t eeprom_size,max_size;
typedef struct _MyData {
                         int16_t sdata;
                         int32_t idata;
                         float fdata;
                       } MyData;

static void myerror(std::string msg)
{
  printf("Error %s\n",msg.c_str());
  exit(1);
}

void StoreCurrentMode(int32_t idata)
{
  EEPROM ep(SDA,SCL,EEPROM_ADDR,EEPROM::T24C32);  // 24C64 eeprom with sda = p9 and scl = p10  
  eeprom_size = ep.getSize();
  max_size = MAX(eeprom_size,256);
  ep.write(10,(int32_t)idata); // long write at address eeprom_size - 12
  if(ep.getError() != 0)
    myerror(ep.getErrorMessage());
    printf("\n");    
    ep.read(10,(int32_t&)idata);
//   printf("TransDC Read %d\r\n",idata);
}



int32_t readCurrentMode()
{
  int32_t idata;
  EEPROM ep(SDA,SCL,EEPROM_ADDR,EEPROM::T24C32);  // 24C64 eeprom with sda = p9 and scl = p10
    eeprom_size = ep.getSize();
  max_size = MAX(eeprom_size,256);
  printf(" Max Size =:%d\r\n",max_size);
 ep.read(10,(int32_t&)idata);
 
 if(ep.getError() != 0)
    myerror(ep.getErrorMessage());
   //printf("\n");
//   printf("Trans Down Count Read %d\r\n",idata);
   return idata;
}

bool WriteCorresspondingTimes(uint32_t currentMode, float gTime,float yTime,float rTime)
{
  EEPROM ep(SDA,SCL,EEPROM_ADDR,EEPROM::T24C32);  // 24C64 eeprom with sda = p9 and scl = p10
  eeprom_size = ep.getSize();
  max_size =  MAX(eeprom_size-200,256);
  
    uint32_t addr = 100*currentMode;
  ep.write(addr,(float)gTime); // float write at address eeprom_size - 8
  if(ep.getError() != 0)
    myerror(ep.getErrorMessage());
  
  // Test read short, long, float
  printf("\nGreen Time : (%f) :\n",gTime);  
 
  
  addr = 100*currentMode +4;
  ep.write(addr,(float)yTime); // float write at address eeprom_size - 8
  if(ep.getError() != 0)
    myerror(ep.getErrorMessage());
  
  // Test read short, long, float
  printf("\nYellow Time : (%f) :\n",yTime);  
  
     addr = 100*currentMode +8;
  ep.write(addr,(float)rTime); // float write at address eeprom_size - 8
  if(ep.getError() != 0)
    myerror(ep.getErrorMessage());
  
  // Test read short, long, float
  printf("\nRed Time : (%f) :\n",rTime);  


}


bool ReadCorresspondingTimes(uint32_t currentMode, float *gTime,float *yTime,float *rTime)
{
  float fdata=0.0;
  EEPROM ep(SDA,SCL,EEPROM_ADDR,EEPROM::T24C32);  // 24C64 eeprom with sda = p9 and scl = p10
    eeprom_size = ep.getSize();
    printf("Size is : %d",eeprom_size);
  max_size = MAX(eeprom_size-200,256);
  printf(" Here 1\r\n");
  uint32_t addr=currentMode*100;
  ep.read(addr,fdata);  
  *gTime=fdata;
  
  fdata=0;
  addr = 100*currentMode +4;
//   ep.read((uint32_t)(max_size - ((currentMode*12)-4)),fdata);  
   ep.read(addr,fdata);  
  *yTime=fdata;
  fdata=0;
  addr = 100*currentMode +8;
//   ep.read((uint32_t)(max_size - ((currentMode*12)-8)),fdata); 
ep.read(addr,fdata);   
  *rTime=fdata;
  printf("1 : %f\r\n",*gTime);
  printf("2 : %f\r\n",*yTime);
  printf("3 : %f\r\n",*rTime);
   
 if(ep.getError() != 0)
    myerror(ep.getErrorMessage());

 
}



void Last_Saved_Mode()
{
  //float Gtime=0,Ytime=0, Rtime=0;
  int32_t CurrentMode= readCurrentMode();  
  bool flag= ReadCorresspondingTimes( CurrentMode, &G_time,&Y_time, &R_time);   
}