
#include "mbed.h"
#include "LCDDisplay.h"
#include "i2ceeprom.h"
#include "Hotboards_keypad.h"
#include "Hotboards_keypad.h"

// Defines the keys array with it's respective number of rows & cols,
// and with the value of each key
char keys[ 4 ][ 4 ] = {
    { '1' , '2' , '3' , 'A' },
    { '4' , '5' , '6' , 'B' },
    { '7' , '8' , '9' , 'C' },
    { '*' , '0' , '#' , 'D' }
};

// Defines the pins connected to the rows
DigitalInOut rowPins[ 4 ] = {D4,D5,D6,D7 };
// Defines the pins connected to the cols
DigitalInOut colPins[ 4 ] = { D8,D9,D10,D11};
//connect to the column pinouts of the keypad

Keypad keypad( makeKeymap( keys ), rowPins, colPins,4,4);


bool PasswordStatus=false;
int mode=0;



DigitalOut GreenLight(PB_1);
DigitalOut YellowLight(PB_15);
DigitalOut RedLight(PB_14);
DigitalOut SpareLight(PB_13);
DigitalOut Buzzer(PC_13);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);



uint32_t Current_Mode=1;

float G_time=0;
float Y_time=0;
float R_time=0;


uint8_t  StartButtonPressed=0;
uint8_t  StopButtonPressed=0;
uint8_t  ReStartButtonPressed=0;
Timer timer;
Timer timerred;
//Thread EveryOneSec;

void keypadEvent(KeypadEvent key);
bool ReadEachLightTime(uint32_t mode,char *mmss);
bool ReadAllTimesofEachMode(uint32_t MODE,char *Greentime,char *Yellowtime,char *Redtime);
void ExtractTimesinSecs(char *greentime,char *yellowtime,char *redtime,float *grntim,float *yeltim,float *redtim);
void SaveTimes(uint32_t Mode,float GreenTime,float YellowTime,float RedTime);
void CalculateTimeElapsed(float TimeElapsed, char *TimeStr);
bool PasswordAcceptance();
int ModeSelectTochange();
 void Get_Time_Elapsed_after_Start(float timeInSec, char * str);
void fn(char rkey);
int main()
{
    bool start=false;
  
    bool lcdflag=true;
    
    char Timestr[10]={'\0'};
    char Buf[17]={'\0'};
    float timeElapsed=0;
    char buff[6]= {'\0'};
    char Buffer[17]= {'\0'};
    Clear_LCD();
    Display_LCD(0,0,"  Initialising  ");
    SpareLight=1;
    GreenLight=1;
    YellowLight=1;
    RedLight=1;
    wait(1);
    Clear_LCD();
    //Current_Mode=1;
//    Last_Saved_Mode();
    Display_LCD(0,0,"Select Mode Or");
    Display_LCD(0,1,"Press Start ");
    G_time=20;
    Y_time=5;
    R_time=10;
    char key;

    
    Current_Mode = readCurrentMode();
    
    //WriteCorresspondingTimes(1, 10,20,30);
//    ReadCorresspondingTimes(1,&G_time,&Y_time,&R_time);

    
    printf("Current Mode is  %d \r\n", Current_Mode);
    
    while(1) {
        
        key=keypad.getKey();
        
        printf("Key is :%c\r\n",key);
        if(key) {
            if(key=='*') {
                PasswordStatus=PasswordAcceptance();
            }
            if(PasswordStatus==true) {
                PasswordStatus=false;
                mode= ModeSelectTochange();
                if(mode>=1 &&  mode <=6) {
                    fn((char)(mode+0x30));
                    mode=0;
                } else {
                    Display_LCD(0,0," Invalid Mode   ");
                    Display_LCD(0,1," Mode b/w 1-6   ");
                    wait(2);

                    Clear_LCD();
                    Display_LCD(0,0,"Select Mode Or");
                    Display_LCD(0,1,"Press Start ");

                }
            }

            else if(key=='A') {
                printf("Started \r\n");
                StartButtonPressed=1;
                StopButtonPressed=0;
                ReStartButtonPressed=0;
                printf("Started \r\n");
                timer.start();

            }

            else if(key=='B') {
                StartButtonPressed=0;
                StopButtonPressed=1;
                ReStartButtonPressed=0;

                printf("Stopped \r\n");
                wait(0.2);
            } 
            
            else if(key=='C') {
                StartButtonPressed=0;
                StopButtonPressed=0;
                ReStartButtonPressed=1;
                timer.stop();
                printf("Reset \r\n");
                wait(0.2);
            }

            else if(key=='D') {
                Clear_LCD();
                Display_LCD(0,0,"Choose Mode");
                wait(0.5);
                char tempkey=keypad.waitForKey();
                if(tempkey>=0x31 && tempkey<=0x36) {
                    char Buff[20]= {'\0'};
                    sprintf(Buff,"Current Mode %c",tempkey);
                    Display_LCD(0,1,Buff);
                    Current_Mode=(int)(tempkey-0x30);
                    StoreCurrentMode(Current_Mode);
                    wait(1);
                    Clear_LCD();

                } else {
                    Display_LCD(0,0,"Invld Mod Entrd");
                    wait(1);
                    Clear_LCD();

                }
            } else
                {}

        }


//        if(Mode1==0)
        if(Current_Mode==1) {
//            printf("Am here in Mode 1\r\n");
           //  G_time=20;
//            Y_time=5;
//            R_time=10;

            ReadCorresspondingTimes(Current_Mode,&G_time,&Y_time,&R_time);
//            printf(" G_time %f, Y Time %f R_time %f :",G_time,Y_time,R_time);
//            printf("Current MOde  1 \r\n");
//            Display_LCD(0,1,"Mode: 1");


            Y_time=Y_time+G_time;
            R_time=R_time+Y_time;
            wait(0.2);
        }

//          if(Mode2==0)
        if(Current_Mode==2) {

          //   G_time=2;
//            Y_time=5;
//            R_time=1;
           Current_Mode=2;
            ReadCorresspondingTimes(Current_Mode,&G_time,&Y_time,&R_time);
            
            printf("Current MOde  2 \r\n");
//            Display_LCD(0,1,"Mode: 2");
            Y_time=Y_time+G_time;
            R_time=R_time+Y_time;
            wait(0.1);
        }

//         if(Mode3==0)
        if(Current_Mode==3) {

          //   G_time=12;
//            Y_time=5;
//            R_time=10;
            Current_Mode=3;
           ReadCorresspondingTimes(Current_Mode,&G_time,&Y_time,&R_time);
            printf("Current MOde  3 \r\n");
//            Display_LCD(0,1,"Mode: 3");
            Y_time=Y_time+G_time;
            R_time=R_time+Y_time;
            wait(0.1);
        }


        //  if(Mode4==0)
        if(Current_Mode==4) {

            //  G_time=20;
//            Y_time=5;
//            R_time=10;
            Current_Mode=4;
            ReadCorresspondingTimes(Current_Mode,&G_time,&Y_time,&R_time);
            printf("Current MOde  1 \r\n");
            Display_LCD(0,1,"Mode: 4");
            Y_time=Y_time+G_time;
            R_time=R_time+Y_time;
            wait(0.2);
        }
//
        if(Current_Mode==5) {

           // G_time=2;
//            Y_time=5;
//            R_time=1;
            Current_Mode=5;
//            printf("Current MOde  2 \r\n");
            ReadCorresspondingTimes(Current_Mode,&G_time,&Y_time,&R_time);
            Display_LCD(0,1,"Mode: 5");
            Y_time=Y_time+G_time;
            R_time=R_time+Y_time;
            wait(0.2);
        }
//
//         if(Mode6==0)
        if(Current_Mode==6) {

           // G_time=12;
//            Y_time=5;
//            R_time=10;
            Current_Mode=3;
//            printf("Current MOde  3 \r\n");
           ReadCorresspondingTimes(Current_Mode,&G_time,&Y_time,&R_time);
            Display_LCD(0,1,"Mode: 6");
            Y_time=Y_time+G_time;
            R_time=R_time+Y_time;
            wait(0.2);
        }


       // if(Start==0) {
//            printf("Started \r\n");
//            StartButtonPressed=1;
//            StopButtonPressed=0;
//            ReStartButtonPressed=0;
//            printf("Started ************ %d \r\n",StartButtonPressed);
//            printf("Started ############## %d \r\n",StopButtonPressed);
//            printf("Started 88888888888888%d \r\n",ReStartButtonPressed);
//
//            timer.start();
//
//        }
//        if(Stop==0) {
//            StartButtonPressed=0;
//            StopButtonPressed=1;
//            ReStartButtonPressed=0;
//
//            printf("Stopped \r\n");
//            wait(0.2);
//
//        }
//
//        if(Reset==0) {
//            StartButtonPressed=0;
//            StopButtonPressed=0;
//            ReStartButtonPressed=1;
//            timer.stop();
//            printf("Reset \r\n");
//            wait(0.2);
//        }


        if(StartButtonPressed==1 && StopButtonPressed==0 && ReStartButtonPressed==0 ) {
            printf("  Read Time %f\r\n",timer.read()); //while
            if(timer.read()<=G_time ) {

                if(lcdflag==true) {
                    Clear_LCD();
                    lcdflag=false;

                }
                
                
//                timer.start();
                printf("  Read Time %f\r\n",timer.read());
                Display_LCD(0,0,"   Green Light  ");
                Get_Time_Elapsed_after_Start(timer.read(),Timestr);
//                 Display_LCD(0,1,Timestr);
                 sprintf(Buf,"      %s     ",Timestr);
                 Display_LCD(0,1,Buf);
                 memset(Buf,'\0',16);
                GreenLight=0;
                YellowLight=1;
                RedLight=1;
              
            } else if( timer.read()>G_time && timer.read()<=Y_time ) {
                Display_LCD(0,0,"  Yellow Light   ");
                 Get_Time_Elapsed_after_Start(timer.read(),Timestr);
                 sprintf(Buf,"      %s     ",Timestr);
                 Display_LCD(0,1,Buf);
                 memset(Buf,'\0',16);
                GreenLight=1;
                YellowLight=0;
                RedLight=1;
                wait(0.1);
                printf("  Read Time %f\r\n",timer.read());
            }

            else if( timer.read()>Y_time  && timer.read()<=R_time ) {
                Display_LCD(0,0,"   Red  Light    ");
                 Get_Time_Elapsed_after_Start(timer.read(),Timestr);
//                 Display_LCD(0,1,Timestr);
                sprintf(Buf,"      %s     ",Timestr);
                 Display_LCD(0,1,Buf);
                 memset(Buf,'\0',16);
                GreenLight=1;
                YellowLight=1;
                RedLight=0;
                timerred.start();
               

                printf("  Read Time %f\r\n",timer.read());
            }
               else if( timer.read()>R_time )
               {
                    GreenLight=1;
                    YellowLight=1;
                    RedLight=1; 
                    timeElapsed=timer.read();
                    timer.stop();
                     printf("Total Time  = %f\r\n",timeElapsed);

            CalculateTimeElapsed(timeElapsed,buff);

            sprintf(Buffer,"Total Time %s",buff);

            Display_LCD(0,0,Buffer);
            memset(Buffer,'\0',17);
            timeElapsed=timerred.read();
            timerred.stop();
            CalculateTimeElapsed(timeElapsed,buff);
            memset(Buffer,'\0',17);
            sprintf(Buffer,"Tim af Red %s",buff);
            Display_LCD(0,1,Buffer);
            memset(Buffer,'\0',17);

            StartButtonPressed=0;
            StopButtonPressed=1;
            ReStartButtonPressed=0;

                   
                }
            
            //else if(timer.read()>R_time) {
//                Display_LCD(0,0,"Time Lmt Excded ");
//                GreenLight=1;
//                YellowLight=1;
//                RedLight=1;
//                wait(0.2);
//
//
//            }

        }
//        timeElapsed=timer.read();
//        CalculateTimeElapsed(timeElapsed,buff);
        if(StartButtonPressed==0 && StopButtonPressed==1 && ReStartButtonPressed==0 ) {
            timeElapsed=timer.read();
            timer.stop();

            printf("Total Time  = %f\r\n",timeElapsed);

            CalculateTimeElapsed(timeElapsed,buff);

            sprintf(Buffer,"Total Time %s",buff);

            Display_LCD(0,0,Buffer);
            memset(Buffer,'\0',17);
            timeElapsed=timerred.read();
            timerred.stop();
            CalculateTimeElapsed(timeElapsed,buff);
            memset(Buffer,'\0',17);
            sprintf(Buffer,"Tim af Red %s",buff);
            Display_LCD(0,1,Buffer);
            memset(Buffer,'\0',17);

            wait(0.1);
            /*******************************************
            * If you want to use Reset Button Comment these lines
            * Presently it is with auto reset
             ******************************************/
               ReStartButtonPressed=1;
                StartButtonPressed=0;
            StopButtonPressed=0;
//                /******************************************/
        }
        if(StartButtonPressed==0 && StopButtonPressed==0 && ReStartButtonPressed==1 ) {

//            Display_LCD(0,0,"Done Resetting");
            StartButtonPressed=0;
            StopButtonPressed=0;
            ReStartButtonPressed=0;
//            Clear_LCD();

        }
        if(StartButtonPressed==0 && StopButtonPressed==0 && ReStartButtonPressed==0 ) {
            GreenLight=1;
            YellowLight=1;
            RedLight=1;
            timer.reset();
            timerred.reset();
//            printf(" Last Line\r\n");
           // Display_LCD(0,0,"Select Mode Or");
//            Display_LCD(0,1,"Press Start ");

            lcdflag=true;
        }

    }
}


void ReadTimes()
{
    char rkey;
    char Str[5]= {'\0'};
    char Star[5]= {'\0'};
    char text[5]= {'\0'};
    char  GreenTime[6]= {'\0'};
    char  YellowTime[6]= {'\0'};
    char  RedTime[6]= {'\0'};
    bool Staus=false;
    rkey=keypad.waitForKey();

    switch(rkey) {

        case '1':

        {
            Staus=ReadAllTimesofEachMode(1,GreenTime,YellowTime,RedTime);
            if(Staus==true) {

                float GTIME=0,YTIME=0,RTIME=0;
                ExtractTimesinSecs(GreenTime,YellowTime,RedTime,&GTIME,&YTIME,&RTIME);
                SaveTimes(1,GTIME,YTIME,RTIME);
                printf(" Times %f  %f  %f \r\n",GTIME,YTIME,RTIME);
            }
            Staus=false;
        }
        break;
        case '2': {
            Staus=ReadAllTimesofEachMode(2,GreenTime,YellowTime,RedTime);
            if(Staus==true) {

                float GTIME=0,YTIME=0,RTIME=0;
                ExtractTimesinSecs(GreenTime,YellowTime,RedTime,&GTIME,&YTIME,&RTIME);
                printf(" Times %f  %f  %f \r\n",GTIME,YTIME,RTIME);
                SaveTimes(2,GTIME,YTIME,RTIME);
            }
            Staus=false;
        }
        break;
        case '3': {
            Staus=ReadAllTimesofEachMode(3,GreenTime,YellowTime,RedTime);
            if(Staus==true) {

                float GTIME=0,YTIME=0,RTIME=0;
                ExtractTimesinSecs(GreenTime,YellowTime,RedTime,&GTIME,&YTIME,&RTIME);
                SaveTimes(3,GTIME,YTIME,RTIME);
            }
            Staus=false;
        }

        break;
        case '4': {
            Staus=ReadAllTimesofEachMode(4,GreenTime,YellowTime,RedTime);
            if(Staus==true) {

                float GTIME=0,YTIME=0,RTIME=0;
                ExtractTimesinSecs(GreenTime,YellowTime,RedTime,&GTIME,&YTIME,&RTIME);
                SaveTimes(4,GTIME,YTIME,RTIME);
            }
            Staus=false;
        }

        break;
        case '5': {
            Staus=ReadAllTimesofEachMode(5,GreenTime,YellowTime,RedTime);
            if(Staus==true) {

                float GTIME=0,YTIME=0,RTIME=0;
                ExtractTimesinSecs(GreenTime,YellowTime,RedTime,&GTIME,&YTIME,&RTIME);
                SaveTimes(5,GTIME,YTIME,RTIME);
            }
            Staus=false;
        }

        break;

        case '6': {
            Staus=ReadAllTimesofEachMode(6,GreenTime,YellowTime,RedTime);
            if(Staus==true) {

                float GTIME=0,YTIME=0,RTIME=0;
                ExtractTimesinSecs(GreenTime,YellowTime,RedTime,&GTIME,&YTIME,&RTIME);
                SaveTimes(6,GTIME,YTIME,RTIME);
            }
            Staus=false;
        }

        break;
        default: {
            printf("No Mode\r\n");
            Clear_LCD();
            Display_LCD(0,0,"  InValid Mode ");
        }
    }


}

bool ReadEachLightTime(uint32_t mode,char *mmss,char *lightTimeName)
{
    Clear_LCD();
    char Buffer[17]= {'\0'};
    char Buffer1[17]="Entr Time Mode:";
    char Buffer2[17]="Tim MM:SS";

    uint8_t index1=0;
    char key='\0';
    char str[6]= {'\0'};
    Clear_LCD();
    sprintf(Buffer,"%s%d",Buffer1,mode);
    Display_LCD(0,0,Buffer);
    memset(Buffer,'\0',16);
    sprintf(Buffer,"%s %s",lightTimeName,Buffer2);
    Display_LCD(0,1,Buffer);

    wait(3);
    Clear_LCD();
    Display_LCD(0,0,"Press # Set ");
    Display_LCD(0,1,"Prss * to Exit ");

    key=keypad.waitForKey();
    if(key=='#') {
        Clear_LCD();
        Display_LCD(0,0,"MM:SS ");
        Display_LCD(0,1,"MM:SS ");
        index1=0;
        while(index1==0 ||(index1<=4 && key !='#' && key!='*')) {
            key=keypad.waitForKey();
            str[index1]=key;
            if(index1==2) {
                str[index1]=':';
                index1++;
                str[index1]=key;
            }
            index1++;
            Display_LCD(0,0,"MM:SS ");
            Display_LCD(0,1,"MM:SS ");
            Display_LCD(0,1,str);
        }
        Clear_LCD();
        Display_LCD(0,0,"Saving Mode ");
        Display_LCD(0,1,str);
        memcpy(mmss,str,5);
        mmss[6]='\0';
        wait(1);
        Clear_LCD();

        return true;
    } else if(key=='*') {
        Display_LCD(0,0,"Mode Not Set    ");
        Display_LCD(0,1,"Retains PrevMode");
        wait (2);
        Clear_LCD();
        return false;
    }
}


bool ReadAllTimesofEachMode(uint32_t MODE,char *Greentime,char *Yellowtime,char *Redtime)
{
    bool Greenflag=false,Yellowflag=false,Redflag=false;
    Greenflag=ReadEachLightTime(MODE,Greentime,"Green");

    if(Greenflag==true) {

        Yellowflag=ReadEachLightTime(MODE,Yellowtime,"Yellow");
        if(Yellowflag==true) {

            Redflag=ReadEachLightTime(MODE,Redtime,"Red");
            if(Redflag==true) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }

    } else
        return false;
}


void ExtractTimesinSecs(char *greentime,char *yellowtime,char *redtime,float *grntim,float *yeltim,float *redtim)
{
    int mins,secs;
    if( greentime[2]==':') {
        mins=(( greentime[0]-0x30)*10)+(greentime[1]-0x30);
        secs=((greentime[3]-0x30)*10)+(greentime[4]-0x30);
    }
    *grntim=mins*60+secs;
    if( yellowtime[2]==':') {
        mins=(( yellowtime[0]-0x30)*10)+(yellowtime[1]-0x30);
        secs=((yellowtime[3]-0x30)*10)+(yellowtime[4]-0x30);
    }
    *yeltim=mins*60+secs;
    if( redtime[2]==':') {
        mins=(( redtime[0]-0x30)*10)+(redtime[1]-0x30);
        secs=((redtime[3]-0x30)*10)+(redtime[4]-0x30);
    }
    *redtim=mins*60+secs;
}

void SaveTimes(uint32_t Mode,float GreenTime,float YellowTime,float RedTime)
{
    bool flag=false;
    flag=WriteCorresspondingTimes(Mode, GreenTime,YellowTime,RedTime);
        
        if(flag==true) {
            Clear_LCD();
            Display_LCD(0,0,"    Mode Save  ");
            Display_LCD(0,1,"     Success   ");
            wait(1);
        } else {
            Clear_LCD();
            Display_LCD(0,0,"    Mode Save  ");
            Display_LCD(0,1,"     Failure   ");
            
            wait(1);
        }
    
}

void CalculateTimeElapsed(float TimeElapsed, char *TimeStr)
{
    memset(TimeStr,'\0',sizeof TimeStr);
    int mins=(int)TimeElapsed/60;
    int secs=(int)TimeElapsed%60;
    sprintf(TimeStr,"%2d:%02d",mins,secs);
}


bool PasswordAcceptance()
{
    Clear_LCD();
    Display_LCD(0,0,"Enter Password ");
    char PasswordStr[5]= {'\0'};
    char temp='\0';
    temp=keypad.waitForKey();
    PasswordStr[0]=temp;
    Display_LCD(0,1,PasswordStr);
    temp=keypad.waitForKey();
    PasswordStr[1]=temp;
    Display_LCD(0,1,PasswordStr);
    temp=keypad.waitForKey();
    PasswordStr[2]=temp;
    Display_LCD(0,1,PasswordStr);
    temp=keypad.waitForKey();
    PasswordStr[3]=temp;
    Display_LCD(0,1,PasswordStr);
    printf("Password Str %s\r\n",PasswordStr);

    if(PasswordStr[0]=='1' && PasswordStr[1] =='1' && PasswordStr[2]=='1' && PasswordStr[3]=='1') {
        Display_LCD(0,0,"Accepted ");
        printf("Accepted\r\n");
        return true;
    }
    return false;
}


int ModeSelectTochange()
{
    Clear_LCD();
    Display_LCD(0,0,"Select Mode 1-6 ");
    char str[2]= {'\0'};
    char temp='\0';
    temp=keypad.waitForKey();
    if(temp>=0x31 && temp<=0x36) {
        Display_LCD(0,1,"Mode Is: ");
        str[0]=temp;
        Display_LCD(9,1,str);
        wait(1);
        return (temp-0x30);
    }
    Display_LCD(0,0,"Invalid Mode");
    return -1;

}

void fn(char rkey)
{
    char GreenTime[10]= {'\0'},YellowTime[10]= {'\0'},RedTime[10]= {'\0'};
    bool Staus=false;
    switch(rkey)

    {
        case '1':

        {
            Staus=ReadAllTimesofEachMode(1,GreenTime,YellowTime,RedTime);
            if(Staus==true) {

                float GTIME=0,YTIME=0,RTIME=0;
                ExtractTimesinSecs(GreenTime,YellowTime,RedTime,&GTIME,&YTIME,&RTIME);
                SaveTimes(1,GTIME,YTIME,RTIME);
                Display_LCD(0,0,"Done Saving ");
                Display_LCD(0,1,"Mode Saved");
                wait(1);
                Clear_LCD();
            }
            Staus=false;
        }
        break;
        case '2': {
            Staus=ReadAllTimesofEachMode(2,GreenTime,YellowTime,RedTime);
            if(Staus==true) {

                float GTIME=0,YTIME=0,RTIME=0;
                ExtractTimesinSecs(GreenTime,YellowTime,RedTime,&GTIME,&YTIME,&RTIME);
                                           SaveTimes(2,GTIME,YTIME,RTIME);
                Display_LCD(0,0,"Done Saving ");
                Display_LCD(0,1,"Mode Saved");
                wait(1);
                Clear_LCD();
            }
            Staus=false;
        }
        break;
        case '3': {
            Staus=ReadAllTimesofEachMode(3,GreenTime,YellowTime,RedTime);
            if(Staus==true) {
                float GTIME=0,YTIME=0,RTIME=0;
                ExtractTimesinSecs(GreenTime,YellowTime,RedTime,&GTIME,&YTIME,&RTIME);
                
                printf("GreenTime,YellowTime,RedTime,&GTIME,&YTIME,&RTIME %s   %s  %s  : %f  %f  %f \r\n ",GreenTime,YellowTime,RedTime,GTIME,YTIME,RTIME);
                SaveTimes(3,GTIME,YTIME,RTIME);
                
                Display_LCD(0,0,"Done Saving ");
                Display_LCD(0,1,"Mode Saved");
                wait(1);
                Clear_LCD();
            }
            Staus=false;
        }

        break;
        case '4': {
            Staus=ReadAllTimesofEachMode(4,GreenTime,YellowTime,RedTime);
            if(Staus==true) {

                float GTIME=0,YTIME=0,RTIME=0;
                ExtractTimesinSecs(GreenTime,YellowTime,RedTime,&GTIME,&YTIME,&RTIME);
                                          SaveTimes(4,GTIME,YTIME,RTIME);
                Display_LCD(0,0,"Done Saving ");
                Display_LCD(0,1,"Mode Saved");
                wait(1);
                Clear_LCD();
            }
            Staus=false;
        }

        break;
        case '5': {
            Staus=ReadAllTimesofEachMode(5,GreenTime,YellowTime,RedTime);
            if(Staus==true) {

                float GTIME=0,YTIME=0,RTIME=0;
                ExtractTimesinSecs(GreenTime,YellowTime,RedTime,&GTIME,&YTIME,&RTIME);
//                                           SaveTimes(5,GTIME,YTIME,RTIME);
                Display_LCD(0,0,"Done Saving ");
                Display_LCD(0,1,"Mode Saved");
                wait(1);
                Clear_LCD();
            }
            Staus=false;
        }

        break;

        case '6': {
            Staus=ReadAllTimesofEachMode(6,GreenTime,YellowTime,RedTime);
            if(Staus==true) {
                float GTIME=0,YTIME=0,RTIME=0;
                ExtractTimesinSecs(GreenTime,YellowTime,RedTime,&GTIME,&YTIME,&RTIME);
                                          SaveTimes(6,GTIME,YTIME,RTIME);
                Display_LCD(0,0,"Done Saving ");
                Display_LCD(0,1,"Mode Saved");
                wait(1);
                Clear_LCD();
            }
            Staus=false;
        }
        break;
        default:
            Display_LCD(0,0,"No Mode saved");
            Display_LCD(0,1,"Retns Prev Mode");
            wait(1);
            Clear_LCD();
            printf("No Mode\r\n");
    }

}




   void Get_Time_Elapsed_after_Start(float timeInSec, char * str)
   {
     memset(str,'\0',6);
     uint8_t  min=(int) timeInSec/60;
     uint8_t  Secs=(int) timeInSec%60;
     
    if(min<10)
    {
     str[0]=0x30;
     str[1]=min+0x30;    
    }
  else  if(min>=10)
    {
     str[0]=(min/10)+0x30;
     str[1]=(min%10)+0x30;    
    }
    
    str[2]=':';
     if(Secs<10)
    {
     str[3]=0x30;
     str[4]=Secs+0x30;    
    }
  else  if(Secs>=10)
    {
     str[3]=(Secs/10)+0x30;
     str[4]=(Secs%10)+0x30;    
    }
    str[5]='\0';
          
 }