#include "mbed.h"
#include "RTC.h"
#include <string>



int Date_Time_Setting(struct tm curt,char *str)
{
    int len=0;
    len= strlen(str);
    printf("len = %d",len);
    if(len < 14)
        return 0;

    curt.tm_mday = ( str[0]-0x30)*10+(str[1]-0x30);
    curt.tm_mon  = ( str[2]-0x30)*10+(str[3]-0x30) -1;
    curt.tm_year = (( str[4]-0x30)*1000 + (str[5]-0x30)*100 + (str[6]-0x30)*10 + (str[7]-0x30)) -1900 ;

    curt.tm_hour=(str[8]-0x30)*10+(str[9]-0x30);
    curt.tm_min=(str[10]-0x30)*10+(str[11]-0x30);
    curt.tm_sec=(str[12]-0x30)*10+(str[13]-0x30);

    time_t epoch = mktime(&curt);
    if (epoch == (time_t) -1) {
        error("Error in clock setting\n");
        // Stop here
    }
    set_time(epoch);
    return 1;
}


int iSetTerminalTime(char *tstring)
{
    int ret=0;
    struct tm curt;
    int index = 0;
    
    uint8_t date, month, hours, minutes, seconds;
    uint16_t year;

    char* token = strtok(tstring, "/ :"); 
    while (token != NULL)
     { 
        index++;
        if(index == 1)
        {
           date = atoi(token); 
        }
        else if(index == 2)
        {
           month  = atoi(token); 
        }
        else if(index == 3)
        {
            year = atoi(token);
        }
        else if(index == 4)
        {
            hours = atoi(token);
        }
        else if(index == 5)
        {
            minutes = atoi(token);
        }
        else if(index == 6)
        {
           seconds = atoi(token); 
        }
        
        printf(" %d %s\n", index, token); 
        token = strtok(NULL, "/ :"); 
     } 

    curt.tm_mday = date;
    curt.tm_mon  = month - 1;
    curt.tm_year = year -1900 ;

    curt.tm_hour = hours;
    curt.tm_min  = minutes;
    curt.tm_sec  = seconds;

    time_t epoch = mktime(&curt);
    
    if (epoch == (time_t) -1) 
    {
        error("Error in clock setting\n");
        // Stop here
    }
    else
    {
        set_time(epoch);
        printf("time is Set: \r\n");
     }
    return ret;
}


int chk_time (char *str)
{
    int HH,MM,SS;
    HH=(str[0]-0x30)*10+(str[1]-0x30);
    MM=(str[2]-0x30)*10+(str[3]-0x30);
    SS=(str[4]-0x30)*10+(str[5]-0x30);

    if ( HH < 0 || HH > 23 || MM < 0 || MM > 59 || SS < 0 || SS > 59 )
        return -1;

    return 1;
}

int chk_date (char *str)
{
    int epos_date=0,epos_month=0,epos_year=0;

    epos_date  = ( str[0]-0x30)*10+(str[1]-0x30);
    epos_month = ( str[2]-0x30)*10+(str[3]-0x30);
    epos_year  = ( str[4]-0x30)*1000+ (str[5]-0x30)*100 + (str[6]-0x30)*10 + (str[7]-0x30);


    if ( epos_month < 1 || epos_date < 1 || epos_date > 31 || epos_month > 12  ||  epos_year < 2008 ) return ERROR ;

    else if(epos_month == 1 || epos_month == 3 || epos_month == 5 || epos_month == 7 ||                                                                     epos_month == 8 || epos_month ==10 ||epos_month == 12) {

        if (epos_date > 31)
            return -1;
    }

    else  if (epos_month == 4 || epos_month == 6 || epos_month == 9 || epos_month == 11) {

        if (epos_date > 30)
            return -1;
    }

    else if  (epos_month == 2 )

    {
        if ( !(epos_year%400) || (epos_year%100 != 0 && epos_year%4==0 ) ) {
            if (epos_date > 29 ) return -1;
        }

        else  if( epos_date > 28 ) return -1;
    }


    return 1;
}

void  Get_Date_Time(char *date_string,char *time_string, char *DTSTRING)
{

    time_t curr_time;
    tm * curr_tm;
    time(&curr_time);
    curr_tm = localtime(&curr_time);
    strftime(date_string,10,"%Y/%m/%d ",curr_tm);
}


void  Get_Date_Time( char *DTSTRING)
{

    time_t curr_time;
    tm * curr_tm;
    time(&curr_time);
    curr_tm = localtime(&curr_time);  
    strftime(DTSTRING,20,"%Y/%m/%d %H:%M:%S",curr_tm);
   // printf("Time is : %s",DTSTRING);
    
}