#include "mbed.h"
#include "EPSON.h"
 
EPSON::EPSON(PinName tx, PinName rx,uint32_t baud)
    :
    _serial_p(new Serial(tx, rx)),
    _serial(*_serial_p)
{
    _serial.baud(baud);
    initialize();
}
 
EPSON::EPSON(Serial &serial_obj, uint32_t baud)
    :
    _serial_p(NULL),
    _serial(serial_obj)
{
    _serial.baud(baud);
    initialize();
}
 
EPSON::~EPSON()
{
}
 
 
void EPSON::initialize(void)
{
    _serial.putc(0x1B);
    _serial.putc(0x40);
    _serial.putc(0x1C);
}
 
 
 void EPSON::printLeft(void)
{
    _serial.putc(0x1B);
    _serial.putc(0x40);
    _serial.putc(0x30);
}

void EPSON::printRight(void)
{
    _serial.putc(0x1B);
    _serial.putc(0x40);
    _serial.putc(0x32);
}



void EPSON::printCenter(void)
{
    _serial.putc(0x1B);
    _serial.putc(0x40);
    _serial.putc(0x31);
}

void EPSON::font_Zero(void)
{
    _serial.putc(0x1D);
    _serial.putc(0x21);
    _serial.putc(0x00);
}

void EPSON::font_OneZero(void)
{
    _serial.putc(0x1D);
    _serial.putc(0x21);
    _serial.putc(0x10);
}

void EPSON::font_ZeroOne(void)
{
    _serial.putc(0x1D);
    _serial.putc(0x21);
    _serial.putc(0x01);
}

  int  EPSON:: PrintBarCode(char *data,int ilen)
  {
    char str_pdata[100];
  char header[] = {0x1D, 0x48, 0x02, 0x1D, 0x66, 0x00, 0x1D, 0x68, 0x51, 0x1D, 0x77, 0x02, 0x1D, 0x6B, 0x49};
  int idata_len, raw_data_len;   
  
  memset(str_pdata, 0x00, sizeof(str_pdata));
  
  memcpy(str_pdata,header, 15); 
  idata_len = 15; 
   
  raw_data_len = ilen + 2; 
  str_pdata[idata_len] = raw_data_len; 

  idata_len++; 
  memcpy(str_pdata+idata_len, "{A", 2); 
  idata_len += 2;  
  memcpy(str_pdata+idata_len, data, ilen);  
  idata_len += ilen;

    _serial.printf("%s",str_pdata ); 
    
   return 1;     
      
    }


void EPSON::printTest(void)
{
    _serial.putc(0x1D);
    _serial.putc(0x28);
    _serial.putc(0x41);
}
 
 
void EPSON::lineFeed(void)
{
    _serial.putc(0x0A);
  
}
 
 
void EPSON::carriageReturn(void)
{
    _serial.putc(0x0D);
}
 
 
 
void EPSON::putLineFeed(uint8_t lines)
{
    for(uint32_t i = 0; i < lines; i++) {
        _serial.putc('\r');
    }
}
 
void EPSON::printnputLineFeed(uint8_t lines)
{
   _serial.putc(0x1B);
   _serial.putc(0x64);
  _serial.putc(lines);
  
  }
 
void EPSON::setdefaultLinespacing(void)
{
   _serial.putc(0x1B);
   _serial.putc(0x32);
  _serial.putc(0x32);
  
  }
  
void EPSON::setLinespacing(uint8_t lines)
{
  uint8_t num=32;
  if(lines==1)
  num=32;
  else if(lines==2)
  num=64;
  else if(lines==3)
  num=96;
  
  
   _serial.putc(0x1B);
   _serial.putc(0x33);
  _serial.putc(num);
  
  }
 
  void EPSON::setleftMargin(uint8_t n1, uint8_t n2)
  {
   _serial.putc(0x1D);
   _serial.putc(0x4C);
  _serial.putc(n1);
  _serial.putc(n2);
  }
 
 void EPSON::absoluteprintPosition(uint8_t n1, uint8_t n2)
  {
   _serial.putc(0x1B);
   _serial.putc(0x24);
  _serial.putc(n1);
  _serial.putc(n2);
  }
 
void EPSON::whiteblack(uint8_t n1)
  {
   _serial.putc(0x1D);
   _serial.putc(0x42);
  _serial.putc(n1);// n1=0   for OFF n1=1 for ON
 
  }
 
  void EPSON::papersensorstatus(void)
  {
  _serial.putc(0x1B);
   _serial.putc(0x76);
 
  // Poll Rx pin of printer Here
  //0x00 Paper Present
  //0x20 Paper Absent
  }
  
void EPSON::printModes(uint8_t n)     
{
    _serial.putc(0x1B);
    _serial.putc(0x21);
    _serial.putc(n);
    
 
 
//Possible values for n    
//00 = 32 Char Normal                                        08 = 32 Char BOLD
//01 = 24 Char Normal                                        09 = 24 Char BOLD
//11 = 24 Char Double Height                                 19 = 24 Char Double Height & BOLD
//21 = 24 Char Double Width                                  29 = 24 Char Double Width & BOLD
//31 = 24 Char Double Height & Double Width                  39 = 24 Char Double Height & Double Width & BOLD
//10 = 32 Char Double Height                                 18 = 32 Char Double Height & BOLD
//20 = 32 Char Double Width                                  28 = 32 Char Double Width & BOLD
//30 = 32 Char Double Height & Double Width                  38 = 32 Char Double Height & Double Width & BOLD
    
}
  
void EPSON::clearBuffer(void)
{
    _serial.putc(0x18);
    
    
//
//[Name]  Clear buffer(s)
//[Format]    
//ASCII       DLE     DC4     fn      d1      d2      d3      d4      d5      d6      d7
//Hex         10      14      08      01      03      14      01      06      02      08
//Decimal     16      20      8       1       3       20      1       6       2       8


_serial.putc(0x10);
_serial.putc(0x14);
_serial.putc(0x08);
_serial.putc(0x01);
_serial.putc(0x03);
_serial.putc(0x14);
_serial.putc(0x01);
_serial.putc(0x06);
_serial.putc(0x02);
_serial.putc(0x08);

}
 
void EPSON::putHorizontaltab(void)
{
    _serial.putc(0x09);
}
 
void EPSON::setDoubleSizeHeight(void)
{
    _serial.printf("\x1D\x21\x01");
}
 
void EPSON::clearDoubleSizeHeight(void)
{
    _serial.printf("\x1D\x21\x00");
}
 
void EPSON::setDoubleSizeWidth(void)
{
    _serial.printf("\x1D\x21\x10");
}
 
void EPSON::clearDoubleSizeWidth(void)
{
        _serial.printf("\x1D\x21\x00");
}
 
void EPSON::setLargeFont(void)
{
    _serial.printf("\x1D\x21\x11");
}
 
void EPSON::clearLargeFont()
{
    _serial.printf("\x1D\x21\x00");
}
 
void EPSON::setANKFont(uint32_t font)
{
    _serial.putc(0x1B);
    _serial.putc(0x68);
    _serial.putc(font);
}
 
void EPSON::setKanjiFont(uint32_t font)
{
    _serial.putc(0x12);
    _serial.putc(0x53);
    _serial.putc(font);
}
 
void EPSON::printQRCode(uint32_t err, const char* param)
{
    uint32_t len = strlen(param);
    char buf[4] = {0x1D, 0x78};
    buf[2] = err;
    buf[3] = len;
    for (uint32_t i = 0; i < sizeof(buf); i++) {
        _serial.putc(buf[i]);
    }
    for (uint32_t i = 0; i < len; i++) {
        _serial.putc(param[i]);
    }
}
 
void EPSON::printBarCode(uint32_t code, const char* param)
{
    char buf[3] = {0x1D, 0x6B};
    buf[2] = code;
    for (uint32_t i = 0; i < sizeof(buf); i++) {
        _serial.putc(buf[i]);
    }
    for (uint32_t i = 0; i < strlen(param); i++) {
        _serial.putc(param[i]);
    }
    _serial.putc('\0');
}
 
void EPSON::printBitmapImage(uint32_t mode, uint16_t lines, const uint8_t * image)
{
    char buf[3] = {0x1C, 0x2A};
    buf[2] = mode;
    for (uint32_t i = 0; i < sizeof(buf); i++) {
        _serial.putc(buf[i]);
    }
    _serial.putc((lines >> 8) & 0xFF); // n1
    _serial.putc((lines >> 0) & 0xFF); // n2
 
    if (mode == 0x61) {
        return;
    }
 
    for (uint32_t i = 0; i < (48 * lines); i++) {
        _serial.putc(image[i]);
    }
}
 
void EPSON::setLineSpaceing(uint32_t space)
{
    _serial.putc(0x1B);
    _serial.putc(0x33);
    _serial.putc(space);
}
 
void EPSON::defaultLineSpaceing()
{
    _serial.printf("\x1B\x33\x04");
}
 
void EPSON::setPrintDirection(uint32_t direction)
{
    _serial.putc(0x1B);
    _serial.putc(0x49);
    _serial.putc(direction);
}
 
void EPSON::putPaperFeed(uint32_t space)
{
    _serial.putc(0x1B);
    _serial.putc(0x4A);
    _serial.putc(space);
}
 
void EPSON::setInterCharacterSpace(uint32_t space)
{
    _serial.putc(0x1B);
    _serial.putc(0x20);
    _serial.putc(space);
}
 
void EPSON::defaultInterCharacterSpace()
{
    _serial.printf("\x1B\x20\x01");
}
 
void EPSON::putPrintPosition(uint32_t position)
{
    _serial.putc(0x1B);
    _serial.putc(0x6c);
    _serial.putc(position);
}
 
void EPSON::setScript(script_mode script)
{
    _serial.putc(0x1B);
    _serial.putc(0x73);
    _serial.putc(script);
}
 
 
 
void EPSON::clearScript()
{
    _serial.printf("\x1B\x73\x30");
}
 
void EPSON::setQuadrupleSize()
{
    _serial.printf("\x1C\x57\x31");
}
 
void EPSON::clearQuadrupleSize()
{
    _serial.printf("\x1C\x57\x30");
}
 
void EPSON::setEnlargement(uint32_t width, uint32_t height)
{
    _serial.putc(0x1C);
    _serial.putc(0x65);
    _serial.putc(width);
    _serial.putc(height);
}
 
void EPSON::clearEnlargement()
{
    _serial.printf("\x1C\x65\x31\x31");
}
 
void EPSON::setBarCodeHeight(uint32_t height)
{
    _serial.putc(0x1D);
    _serial.putc(0x68);
    _serial.putc(height);
}
 
void EPSON::defaultBarCodeHeight()
{
    _serial.printf("\x1D\x68\x50");
}
 
 
 
void EPSON::setBarCodeBarSize(uint32_t narrowbar, uint32_t widebar)
{
    _serial.putc(0x1D);
    _serial.putc(0x77);
    _serial.putc(narrowbar);
    _serial.putc(widebar);
}
 
 
void EPSON::defaultBarCodeBarSize()
{
    _serial.printf("\x1D\x77\x02\x05");
}
 
int EPSON::_putc(int value)
{
    _serial.putc(value);
    return value;
}
 
int EPSON::_getc()
{
    return -1;
}