// EE25LC1024.h

#ifndef EE25LC1024_H
#define EE25LC1024_H

#include "mbed.h"
#include <string>

#define SPI_Freq        10000000                 //Change SPI Frequency Here
#define SPI_MODE        0                       // SPI Mode can be 0 or 3 . see data sheet
#define SPI_NBIT        8                       // Number of bits 8.



#define DUMMY_ADDR      0x00
#define WAIT_TIME       1

#define ADDR_BMASK3     0xff000000
#define ADDR_BMASK2     0x00ff0000
#define ADDR_BMASK1     0x0000ff00
#define ADDR_BMASK0     0x000000ff

#define ADDR_BSHIFT3    24
#define ADDR_BSHIFT2    16
#define ADDR_BSHIFT1    8
#define ADDR_BSHIFT0    0


#define     READ            0x03        //0000 0011 Read data from memory array beginning at selected address
#define     WRITE           0x02        //0000 0010 Write data to memory array beginning at selected address
#define     WREN            0x06        //0000 0110 Set the write enable latch (enable write operations)
#define     WRDI            0x04        //0000 0100 Reset the write enable latch (disable write operations)
#define     RDSR            0x05        //0000 0101 Read STATUS register
#define     WRSR            0x01        //0000 0001 Write STATUS register
#define     PE              0x42        //0100 0010 Page Erase – erase one page in memory array
#define     SE              0xD8        //1101 1000 Sector Erase – erase one sector in memory array
#define     CE              0xC7        //1100 0111 Chip Erase – erase all sectors in memory array
#define     Readid          0xAB        //1010 1011 Release from Deep power-down and read electronic signature
#define     DPD             0xB9        //1011 1001 Deep Power-Down mode
#define     DUMMYBYTE       0x00        //Dummy byte for Read Operation

class EE25LC1024: public SPI {
public:
    EE25LC1024(PinName mosi, PinName miso, PinName sclk, PinName cs);
    
    void deepPowerDown(void);
    
    
    int readByte(int addr);                                 // takes a 24-bit (3 bytes) address and returns the data (1 byte) at that location                   
    void readStream(int addr, char* buf, int count);        // takes a 24-bit address, reads count bytes, and stores results in buf
    int ReleaseDPD_ReadSign(void);
    void writeByte(int addr, int data);                     // takes a 24-bit (3 bytes) address and a byte of data to write at that location
    void writeStream(int addr, char* buf, int count);       // write count bytes of data from buf to memory, starting at addr  
    void writeString(int add, string str);
    void sectorErase(int addr);
    void pageErase(int addr);
    void chipErase();                                       //erase all data on chip
    uint8_t readRegister();  
    uint8_t checkIfBusy();                                  // Check if IC is bury writing or erasing 
    void writeRegister(uint8_t regValue);                   // Write status register or configuration register                                   
    long readLong(int address);                             // Read long int number
    void writeLong(int addr, long value);                   // Write Long Integer Number
private:
    void writeEnable();                                     // write enable
    void writeDisable();                                    // write disable
    void chipEnable();                                      // chip enable
    void chipDisable();  
                                      // chip disable
    
   // SPI _spi;
    DigitalOut _cs;
};

#endif