// EE25LC1024.cpp
#include "mbed.h"
#include"EE25LC1024.h"

// CONSTRUCTOR
EE25LC1024::EE25LC1024(PinName mosi, PinName miso, PinName sclk, PinName cs) : SPI(mosi, miso, sclk), _cs(cs)
{
    this->format(SPI_NBIT, SPI_MODE);
    this->frequency(SPI_Freq);
    chipDisable();

}
// READING


void EE25LC1024::deepPowerDown(void)
{ 
    chipEnable();
    this->write(DPD);
    chipDisable();  
}
    
  int EE25LC1024::ReleaseDPD_ReadSign(void)
{ 
    chipEnable();
    this->write(Readid);
    this->write(DUMMY_ADDR);
    this->write(DUMMY_ADDR);
    this->write(DUMMY_ADDR);
     int response = this->write(DUMMY_ADDR);
    chipDisable(); 
    return response; 
}  
    
    
int EE25LC1024::readByte(int addr)
{
    chipEnable();
    this->write(READ);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    int response = this->write(DUMMY_ADDR);
    chipDisable();
    return response;
}

void EE25LC1024::readStream(int addr, char* buf, int count)
{
    if (count < 1)
        return;
    chipEnable();
    this->write(READ);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    for (int i = 0; i < count; i++) {
        buf[i] =  this->write(DUMMY_ADDR);
       // printf("i= %d   :%c \r\n",i,buf[i]);
    }
    chipDisable();
  //  wait_ms(2);
}

// WRITING
void EE25LC1024::writeByte(int addr, int data)
{
    writeEnable();
    chipEnable();
    this->write(WRITE);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    this->write(data);
    chipDisable();
    writeDisable();
    wait_ms(6);
    // wait(WAIT_TIME);//instead of wait poll for WIP flag of status reg or use checkIfBusy() function...see main for more dtails 
}

void EE25LC1024::writeStream(int addr, char* buf, int count)
{

    if (count < 1)
        return;
        
    writeEnable();
    
 
    
    chipEnable();
    this->write(WRITE);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    for (int i = 0; i < count; i++) {
        this->write(buf[i]);
    }
    chipDisable();
    writeDisable();
     wait_ms(2);
   uint8_t busy= checkIfBusy(); 
   while(busy==1)
   {
       //printf("Busy   :%d\r\n",busy);
       wait_ms(1);
       busy= checkIfBusy();
    }
    }

void EE25LC1024::writeString(int addr, string str)
{
    if (str.length() < 1)
        return;
    writeEnable();
    chipEnable();
    this->write(WRITE);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    for (int i = 0; i < str.length(); i++)
        this->write(str.at(i));
    chipDisable();
    writeDisable();
    wait_ms(6);//instead of wait poll for WIP flag of status reg or use checkIfBusy() function...see main for more dtails 
}



uint8_t EE25LC1024::readRegister()
{

    chipEnable();
    this->write(RDSR);
    uint8_t val=this->write(DUMMY_ADDR);
    chipDisable();
   //wait(WAIT_TIME);//instead of wait poll for WIP flag of status reg or use checkIfBusy() function...see main for more dtails 
   //printf("value of reg is %X  \r\n",val);
    return(val);
}
//ERASING
void EE25LC1024::chipErase()
{
    writeEnable();
    chipEnable();
    this->write(CE);
    chipDisable();
    writeDisable();
    wait_ms(10);//instead of wait poll for WIP flag of status reg or use checkIfBusy() function...see main for more dtails 
}


void EE25LC1024::sectorErase(int addr)
{
    writeEnable();
    chipEnable();
    this->write(SE);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    chipDisable();
    writeDisable();
    wait_ms(10);//instead of wait poll for WIP flag of status reg or use checkIfBusy() function...see main for more dtails 
}

void EE25LC1024::pageErase(int addr)
{
    
    writeEnable();
    
    chipEnable();
    
    this->write(SE);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    chipDisable();
    writeDisable();
    wait_ms(6);//instead of wait poll for WIP flag of status reg or use checkIfBusy() function...see main for more dtails 
     
    
}


uint8_t EE25LC1024::checkIfBusy()
{
    uint8_t value=readRegister();
   // printf("\r\n Value of Status Reg=%X\r\n\r\n",value);
    if((value & 0x01)==0x01 )
    {
        wait_ms(1);
        return 1;
        }
    else
    {
        wait_ms(1);
        return 0;
        }
}

void EE25LC1024::writeRegister(uint8_t regValue)
{
    writeEnable();
    chipEnable();
    this->write(WRSR);
    this->write(regValue);
    chipDisable();
    writeDisable();
    wait(WAIT_TIME);//instead of wait poll for WIP flag of status reg or use checkIfBusy() function...see main for more dtails 

}


void EE25LC1024::writeLong(int addr, long value)
{
    //Decomposition from a long to 4 bytes by using bitshift.
    //One = Most significant -> Four = Least significant byte
    uint8_t four = (value & 0xFF);
    uint8_t three = ((value >> 8) & 0xFF);
    uint8_t two = ((value >> 16) & 0xFF);
    uint8_t one = ((value >> 24) & 0xFF);

    writeEnable();
    chipEnable();
    this->write(WRITE);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);
    this->write(four);
    this->write(three);
    this->write(two);
    this->write(one);
    chipDisable();
    writeDisable();
    wait_ms(6);
}

long EE25LC1024::readLong(int addr)
{
    //Read the 4 bytes from the eeprom memory.
    chipEnable();
    this->write(READ);
    this->write((addr & ADDR_BMASK2) >> ADDR_BSHIFT2);
    this->write((addr & ADDR_BMASK1) >> ADDR_BSHIFT1);
    this->write((addr & ADDR_BMASK0) >> ADDR_BSHIFT0);

    long four = this->write(DUMMY_ADDR);
    long three = this->write(DUMMY_ADDR);
    long two = this->write(DUMMY_ADDR);
    long one = this->write(DUMMY_ADDR);
    chipDisable();
    //Return the recomposed long by using bitshift.
    return ((four << 0) & 0xFF) + ((three << 8) & 0xFFFF) + ((two << 16) & 0xFFFFFF) + ((one << 24) & 0xFFFFFFFF);
    
}


//ENABLE/DISABLE (private functions)
void EE25LC1024::writeEnable()
{
    chipEnable();
    this->write(WREN);
    chipDisable();
}
void EE25LC1024::writeDisable()
{
    chipEnable();
    this->write(WRDI);
    chipDisable();
}
void EE25LC1024::chipEnable()
{
    _cs = 0;
}
void EE25LC1024::chipDisable()
{
    _cs = 1;
}

