

#include "mbed.h"
#include "APSEPM207LV.h"

APSEPM207LV::APSEPM207LV(PinName tx, PinName rx,uint32_t baud)
    :
    _serial_p(new Serial(tx, rx)),
    _serial(*_serial_p)
{
    _serial.baud(baud);
    initialize();
}

APSEPM207LV::APSEPM207LV(Serial &serial_obj, uint32_t baud)
    :
    _serial_p(NULL),
    _serial(serial_obj)
{
    _serial.baud(baud);
    initialize();
}

APSEPM207LV::~APSEPM207LV()
{
}


void APSEPM207LV::initialize(void)
{
    _serial.putc(0x1B);
    _serial.putc(0x40);
}

void APSEPM207LV::printTest(void)
{
    _serial.putc(0x1D);
    _serial.putc(0x28);
    _serial.putc(0x41);
}


void APSEPM207LV::lineFeed(void)
{
    _serial.putc(0x0A);
  
}


void APSEPM207LV::carriageReturn(void)
{
    _serial.putc(0x0D);
}



void APSEPM207LV::putLineFeed(uint8_t lines)
{
    for(uint32_t i = 0; i < lines; i++) {
        _serial.putc('\r');
    }
}

void APSEPM207LV::printnputLineFeed(uint8_t lines)
{
   _serial.putc(0x1B);
   _serial.putc(0x64);
  _serial.putc(lines);
  
  }

void APSEPM207LV::setdefaultLinespacing(void)
{
   _serial.putc(0x1B);
   _serial.putc(0x32);
  _serial.putc(0x32);
  
  }
  
void APSEPM207LV::setLinespacing(uint8_t lines)
{
  uint8_t num=32;
  if(lines==1)
  num=32;
  else if(lines==2)
  num=64;
  else if(lines==3)
  num=96;
  
  
   _serial.putc(0x1B);
   _serial.putc(0x33);
  _serial.putc(num);
  
  }

  void APSEPM207LV::setleftMargin(uint8_t n1, uint8_t n2)
  {
   _serial.putc(0x1D);
   _serial.putc(0x4C);
  _serial.putc(n1);
  _serial.putc(n2);
  }

 void APSEPM207LV::absoluteprintPosition(uint8_t n1, uint8_t n2)
  {
   _serial.putc(0x1B);
   _serial.putc(0x24);
  _serial.putc(n1);
  _serial.putc(n2);
  }

void APSEPM207LV::whiteblack(uint8_t n1)
  {
   _serial.putc(0x1D);
   _serial.putc(0x42);
  _serial.putc(n1);// n1=0   for OFF n1=1 for ON
 
  }

  void APSEPM207LV::papersensorstatus(void)
  {
  _serial.putc(0x1B);
   _serial.putc(0x76);

  // Poll Rx pin of printer Here
  //0x00 Paper Present
  //0x20 Paper Absent
  }
  
void APSEPM207LV::printModes(uint8_t n)     
{
    _serial.putc(0x1B);
    _serial.putc(0x21);
    _serial.putc(n);
    


//Possible values for n    
//00 = 32 Char Normal                                        08 = 32 Char BOLD
//01 = 24 Char Normal                                        09 = 24 Char BOLD
//11 = 24 Char Double Height                                 19 = 24 Char Double Height & BOLD
//21 = 24 Char Double Width                                  29 = 24 Char Double Width & BOLD
//31 = 24 Char Double Height & Double Width                  39 = 24 Char Double Height & Double Width & BOLD
//10 = 32 Char Double Height                                 18 = 32 Char Double Height & BOLD
//20 = 32 Char Double Width                                  28 = 32 Char Double Width & BOLD
//30 = 32 Char Double Height & Double Width                  38 = 32 Char Double Height & Double Width & BOLD
    
}
  
void APSEPM207LV::clearBuffer(void)
{
    _serial.putc(0x18);
}

void APSEPM207LV::putHorizontaltab(void)
{
    _serial.putc(0x09);
}

void APSEPM207LV::setDoubleSizeHeight(void)
{
    _serial.printf("\x1D\x21\x01");
}

void APSEPM207LV::clearDoubleSizeHeight(void)
{
    _serial.printf("\x1D\x21\x00");
}

void APSEPM207LV::setDoubleSizeWidth(void)
{
    _serial.printf("\x1D\x21\x10");
}

void APSEPM207LV::clearDoubleSizeWidth(void)
{
        _serial.printf("\x1D\x21\x00");
}

void APSEPM207LV::setLargeFont(void)
{
    _serial.printf("\x1D\x21\x11");
}

void APSEPM207LV::clearLargeFont()
{
    _serial.printf("\x1D\x21\x00");
}

void APSEPM207LV::setANKFont(uint32_t font)
{
    _serial.putc(0x1B);
    _serial.putc(0x68);
    _serial.putc(font);
}

void APSEPM207LV::setKanjiFont(uint32_t font)
{
    _serial.putc(0x12);
    _serial.putc(0x53);
    _serial.putc(font);
}

void APSEPM207LV::printQRCode(uint32_t err, const char* param)
{
    uint32_t len = strlen(param);
    char buf[4] = {0x1D, 0x78};
    buf[2] = err;
    buf[3] = len;
    for (uint32_t i = 0; i < sizeof(buf); i++) {
        _serial.putc(buf[i]);
    }
    for (uint32_t i = 0; i < len; i++) {
        _serial.putc(param[i]);
    }
}

void APSEPM207LV::printBarCode(uint32_t code, const char* param)
{
    char buf[3] = {0x1D, 0x6B};
    buf[2] = code;
    for (uint32_t i = 0; i < sizeof(buf); i++) {
        _serial.putc(buf[i]);
    }
    for (uint32_t i = 0; i < strlen(param); i++) {
        _serial.putc(param[i]);
    }
    _serial.putc('\0');
}

void APSEPM207LV::printBitmapImage(uint32_t mode, uint16_t lines, const uint8_t * image)
{
    char buf[3] = {0x1C, 0x2A};
    buf[2] = mode;
    for (uint32_t i = 0; i < sizeof(buf); i++) {
        _serial.putc(buf[i]);
    }
    _serial.putc((lines >> 8) & 0xFF); // n1
    _serial.putc((lines >> 0) & 0xFF); // n2

    if (mode == 0x61) {
        return;
    }

    for (uint32_t i = 0; i < (48 * lines); i++) {
        _serial.putc(image[i]);
    }
}

void APSEPM207LV::setLineSpaceing(uint32_t space)
{
    _serial.putc(0x1B);
    _serial.putc(0x33);
    _serial.putc(space);
}

void APSEPM207LV::defaultLineSpaceing()
{
    _serial.printf("\x1B\x33\x04");
}

void APSEPM207LV::setPrintDirection(uint32_t direction)
{
    _serial.putc(0x1B);
    _serial.putc(0x49);
    _serial.putc(direction);
}

void APSEPM207LV::putPaperFeed(uint32_t space)
{
    _serial.putc(0x1B);
    _serial.putc(0x4A);
    _serial.putc(space);
}

void APSEPM207LV::setInterCharacterSpace(uint32_t space)
{
    _serial.putc(0x1B);
    _serial.putc(0x20);
    _serial.putc(space);
}

void APSEPM207LV::defaultInterCharacterSpace()
{
    _serial.printf("\x1B\x20\x01");
}

void APSEPM207LV::putPrintPosition(uint32_t position)
{
    _serial.putc(0x1B);
    _serial.putc(0x6c);
    _serial.putc(position);
}

void APSEPM207LV::setScript(script_mode script)
{
    _serial.putc(0x1B);
    _serial.putc(0x73);
    _serial.putc(script);
}



void APSEPM207LV::clearScript()
{
    _serial.printf("\x1B\x73\x30");
}

void APSEPM207LV::setQuadrupleSize()
{
    _serial.printf("\x1C\x57\x31");
}

void APSEPM207LV::clearQuadrupleSize()
{
    _serial.printf("\x1C\x57\x30");
}

void APSEPM207LV::setEnlargement(uint32_t width, uint32_t height)
{
    _serial.putc(0x1C);
    _serial.putc(0x65);
    _serial.putc(width);
    _serial.putc(height);
}

void APSEPM207LV::clearEnlargement()
{
    _serial.printf("\x1C\x65\x31\x31");
}

void APSEPM207LV::setBarCodeHeight(uint32_t height)
{
    _serial.putc(0x1D);
    _serial.putc(0x68);
    _serial.putc(height);
}

void APSEPM207LV::defaultBarCodeHeight()
{
    _serial.printf("\x1D\x68\x50");
}

void APSEPM207LV::setBarCodeBarSize(uint32_t narrowbar, uint32_t widebar)
{
    _serial.putc(0x1D);
    _serial.putc(0x77);
    _serial.putc(narrowbar);
    _serial.putc(widebar);
}

void APSEPM207LV::defaultBarCodeBarSize()
{
    _serial.printf("\x1D\x77\x02\x05");
}

int APSEPM207LV::_putc(int value)
{
    _serial.putc(value);
    return value;
}

int APSEPM207LV::_getc()
{
    return -1;
}



