/****************************************************************************
 ****** 3-axis Accelerometer ADXL335 or GY-61 interfacing to FRDM-KL25Z *****
 ******                  Author :  SHIVAM TRIPATHI                     ******  
 ***************************************************************************/

#include "mbed.h"

Serial pc(USBTX, USBRX);
AnalogIn analog_value1(A0);  //Output of X-axis at analog pin A0  ........ (Refer pinout)
AnalogIn analog_value2(A1);  //Output of y-axis at analog pin A1
AnalogIn analog_value3(A2);  //Output of z-axis at analog pin A1

DigitalOut led(LED1);

int main() {
    int x,y,z;
    
    printf("\nAnalogIn example\n");
    
    while(1) {
        x = analog_value1.read_u16();           // Reads X-axis value and then converts in 16 bit format (3.3V --> 65535).........Analog values are read
        y = analog_value2.read_u16();           // Reads Y-axis value and then converts in 16 bit format (3.3V --> 65535)
        z = analog_value3.read_u16();           // Reads Z-axis value and then converts in 16 bit format (3.3V --> 65535)
        printf("\r x = %d  y = %d  z = %d  \n", x,y,z);    //Prints output on pc Serial terminal (serial USB com driver is a must)
        wait(0.5); // 500 ms
        
    }
}
