#pragma once

#include "mbed.h"
#include "I2CMotorDriver.h"

class DoorController {
public:
    enum DoorState {
        DOOR_OPENED,
        DOOR_CLOSED,
    };
    I2CMotorDriver* p_motor;
    DoorState state;
    
    DoorController(I2CMotorDriver& motor) {
        p_motor = &motor;
        state = DOOR_CLOSED;
    }
    
    void open() {
        if (state == DOOR_OPENED) return;
        
        p_motor->step(-45, 1, 1);
        state = DOOR_OPENED;
    }
    
    void close() {
        if (state == DOOR_CLOSED) return;
        
        p_motor->step(50, 1, 1);
        state = DOOR_CLOSED;
    }
    
    void forceClose() {
        p_motor->step(100, 1, 1);
        state = DOOR_CLOSED;
    }
};
