/**
 * A test program for Pachube API interface driver. (Version 0.0.1)
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

#include "mbed.h"
#include "PachubeV2CSV.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "ThermistorMCP9701.h"

#define API_KEY "YourAPIKey"
#define FEED_ID 99999
#define STREAM_ID1 "TempNo.1"
#define STREAM_ID2 "TempNo.2"
#define STREAM_ID3 "TempNo.3"
#define STREAM_ID4 "TempNo.4"
#define STREAM_ID5 "TempNo.5"

PachubeV2CSV web(API_KEY);
EthernetNetIf eth;
ThermistorMCP9701 thermistor1(p15);
ThermistorMCP9701 thermistor2(p16);
ThermistorMCP9701 thermistor3(p17);
ThermistorMCP9701 thermistor4(p19);
ThermistorMCP9701 thermistor5(p20);

/**
 * Convert double to char.
 *
 * @param val Value.
 * @param buf A pointer to a buffer.
 * @param bufsiz The buffer size.
 */
void convertDoubleToChar(double val, char *buf, size_t bufsiz) {
    snprintf(buf, bufsiz, "%f", val);
}

/**
 * Probe temperatures.
 *
 * @param interval_min probing interval time.
 */
void probe_temperatures(const int interval_min) {
    int cnt = 0;
    while (1) {
        char val1[16];
        char val2[16];
        char val3[16];
        char val4[16];
        char val5[16];
        convertDoubleToChar(thermistor1.read(), val1, sizeof(val1));
        convertDoubleToChar(thermistor2.read(), val2, sizeof(val2));
        convertDoubleToChar(thermistor3.read(), val3, sizeof(val3));
        convertDoubleToChar(thermistor4.read(), val4, sizeof(val4));
        convertDoubleToChar(thermistor5.read(), val5, sizeof(val5));
        if (cnt == 0) {
            printf("createNewDataStream(%d)\n", web.createNewDataStream(FEED_ID, STREAM_ID1, std::string(val1)));
            printf("createNewDataStream(%d)\n", web.createNewDataStream(FEED_ID, STREAM_ID2, std::string(val2)));
            printf("createNewDataStream(%d)\n", web.createNewDataStream(FEED_ID, STREAM_ID3, std::string(val3)));
            printf("createNewDataStream(%d)\n", web.createNewDataStream(FEED_ID, STREAM_ID4, std::string(val4)));
            printf("createNewDataStream(%d)\n", web.createNewDataStream(FEED_ID, STREAM_ID5, std::string(val5)));
        } else {
            printf("updateDataStream(%d)\n", web.updateDataStream(FEED_ID, STREAM_ID1, std::string(val1)));
            printf("updateDataStream(%d)\n", web.updateDataStream(FEED_ID, STREAM_ID2, std::string(val2)));
            printf("updateDataStream(%d)\n", web.updateDataStream(FEED_ID, STREAM_ID3, std::string(val3)));
            printf("updateDataStream(%d)\n", web.updateDataStream(FEED_ID, STREAM_ID4, std::string(val4)));
            printf("updateDataStream(%d)\n", web.updateDataStream(FEED_ID, STREAM_ID5, std::string(val5)));
        }
        cnt++;

        /*
         * This is not exactlly same as interval_min[min.].
         * But I think this codes are good starting point for you.
         */
        for (int i = 0; i < interval_min; i++) {
            /*
             * Wait 60 seconds.
             */
            wait(60);
            printf("%d[min.]\n", i + 1);
        }
    }
}

/**
 * Entry point.
 */
int main() {
    eth.setup();

    const int IntervalMinutes = 5;
    probe_temperatures(IntervalMinutes);
}
