/* mbed Microcontroller Sample Program
 * Copyright (c) 2013 Shinichiro Nakamura
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "mbed.h"
#include "TouchSense.h"
 
TouchSense ts1(p15);
TouchSense ts2(p16);
TouchSense ts3(p17);
TouchSense ts4(p18);
TouchSense ts5(p19);
TouchSense ts6(p20);
 
int main() {
    ts1.calibration();
    ts2.calibration();
    ts3.calibration();
    ts4.calibration();
    ts5.calibration();
    ts6.calibration();
    while (true) {
        printf("[%c%c%c%c%c%c]\r\n",
            ts1.sense() ? 'o' : '.',
            ts2.sense() ? 'o' : '.',
            ts3.sense() ? 'o' : '.',
            ts4.sense() ? 'o' : '.',
            ts5.sense() ? 'o' : '.',
            ts6.sense() ? 'o' : '.');
        wait(0.050);
    }
}