/**
 * Thermistor interface driver. (Version 0.0.1)
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

#include "ThermistorDummy.h"

ThermistorDummy::ThermistorDummy()
        : memory(getNextValue(MIN + ((MAX - MIN)/2))) {
}

ThermistorDummy::~ThermistorDummy() {
}

double ThermistorDummy::read() {
    memory = getNextValue(memory);
    return memory;
}

double ThermistorDummy::getNextValue(double prev) {
    static const int THR = 5;
    int SCOPE = (MAX - MIN) + 1;
    int tmp = 0;
    do {
        tmp = (rand() % SCOPE) + MIN;
    } while (THR < abs(tmp - prev));
    int udt = rand() % 10;
    return (double)tmp + (double)(udt * 0.1);
}
