
#include "mbed.h"
#include "micro.h"
#include "TextLCD.h"
#include "SDFileSystem.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30);
SDFileSystem fs_sd(p5, p6, p7, p8, "sd");
char *filename = "/sd/target.xsv";

/**
 * Callback function.
 *
 * @param done Done.
 * @param total Total.
 */
void cbfunc_progress(int done, int total) {
    if (total != 0) {
        static int n = 0;
        int tmp = done * 100 / total;
        if (tmp != n) {
            n = tmp;
            lcd.locate(0, 1);
            lcd.printf("Progress: %3d%%", n);
        }
    }
}

/**
 * Callback function.
 *
 * @param microsec Micro seconds.
 */
void cbfunc_waittime(int microsec) {
    int n = microsec / 1000 / 1000;
    if (n > 0) {
        lcd.locate(0, 1);
        lcd.printf("Wait %d sec.", n);
    }
}

/**
 * Entry point.
 */
int main() {
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("mbed XSVF Player");
    wait(2);

    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("mbed XSVF Player");
    int r = execute_micro(filename, &cbfunc_progress, &cbfunc_waittime);
    lcd.locate(0, 1);
    lcd.printf("Done with code %d", r);
    
    return 0;
}
