/**
 * Test program for a bug. (http://mbed.org/forum/bugs-suggestions/topic/990/)
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

#include "mbed.h"

/**
 * TEST_MODE 0: Test a Timeout.
 * TEST_MODE 1: Test a Ticker.
 */
#define TEST_MODE 0

#if TEST_MODE

/*
 * A test for Ticker.
 */

BusOut myled(LED4, LED3, LED2, LED1);
Ticker tickerForLED;
Ticker tickerForAnother;

/**
 * Tick function for toggle 4 LEDs.
 */
void tickfunc_led(void) {
    myled = myled + 1;
}

/**
 * Tick function for another ticker.
 */
void tickfunc_another(void) {
    // Do nothing.
}

/**
 * Entry point for Ticker.
 */
int main(void) {
    int n = 0;

    /*
     * Start my LED ticker.
     */
    tickerForLED.attach(&tickfunc_led, 0.2);

    /*
     * Wait 5 seconds.
     */
    wait(5);

    /*
     * Attach another ticker.
     * Then the LED ticker will be stop.
     */
    while (1) {
        /*
         * Check for this loop.
         */
        printf("n=%d\n", n++);

        /*
         * Change my another ticker.
         */
        tickerForAnother.attach_us(&tickfunc_another, 2 * 1000);
        wait_ms(100);
    }
}

#else

/*
 * A test for Timeout.
 */

BusOut myled(LED4, LED3, LED2, LED1);
Ticker tickerForLED;
Timeout timeout;

/**
 * Tick function for toggle 4 LEDs.
 */
void tickfunc_led(void) {
    myled = myled + 1;
}

/**
 * Timeout function.
 */
void timeoutfunc(void) {
    printf("timeoutfunc.\n");
}

/**
 * Entry point for Timeout.
 */
int main(void) {
    int n = 0;

    /*
     * Start my LED ticker.
     */
    tickerForLED.attach(&tickfunc_led, 0.2);

    /*
     * Wait 5 seconds.
     */
    wait(5);

    /*
     * Attach timeout.
     * Then the LED ticker will be stop.
     */
    while (1) {
        /*
         * Check for this loop.
         */
        printf("n=%d\n", n++);

        /*
         * Change my timeout.
         */
        timeout.detach();
        timeout.attach_us(&timeoutfunc, 2 * 1000);
        wait_ms(100);

        timeout.detach();
        timeout.attach_us(&timeoutfunc, 200 * 1000);
        wait_ms(100);
        
        timeout.attach_us(&timeoutfunc, 20 * 1000);
        wait_ms(100);

        timeout.attach_us(&timeoutfunc, 200 * 1000);
        wait_ms(100);
    }
}

#endif
