/**
 * Test program for a bug. (http://mbed.org/forum/bugs-suggestions/topic/1074/)
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

#include "mbed.h"
#include "Semaphore.h"

Serial ser(USBTX, USBRX);
Ticker ticker;
BusOut led(LED4, LED3, LED2, LED1);
Semaphore sem;

volatile char shared_resource;   // This is a shared resource for example.

#define LOCK() sem.try_enter()
#define UNLOCK() sem.release()

/**
 * a ticker.
 */
void func_tick(void) {
    led = led + 1;
}

/**
 * A call back function for serial interrupt.
 */
void func_serial_interrupt(void) {
    if (LOCK()) {
        shared_resource = ser.getc();
        UNLOCK();
    }
}

/**
 * Entry point.
 */
int main() {
    ticker.attach_us(&func_tick, 100 * 1000);
    ser.attach(&func_serial_interrupt);
    while (1) {
        /*
         * Hung up serial communication if you hit keys on console for Serial.
         */
        if (LOCK()) {
            if (ser.writeable()) {
                ser.printf("0x%x\n", shared_resource);
            }
            UNLOCK();
        }
        wait_ms(100);
    }
}
