#ifndef _SEMAPHORE_H_
#define _SEMAPHORE_H_

/*
 * http://mbed.org/forum/mbed/topic/181/#comment-799
 */

class Semaphore {
public:
    Semaphore(): s(SemFree) {}
    bool try_enter() {
        int oldval = __ldrex(&s);
        if (oldval == SemTaken) {
            return false;
        }
        __strex(SemTaken, &s);
        return true;
    }
    void release() {
        __strex(SemFree, &s);
        s = SemFree;
    }
private:
    enum { SemFree, SemTaken };
    volatile int s;
};

#endif