#include "mbed.h"
#include "EthernetNetIf.h"
#include "SuperTweetV1XML.h"

#define YOUR_ACCOUNT    "YOUR_ACCOUNT"
#define YOUR_PASSWORD   "YOUR_PASSWORD"

extern "C" void mbed_reset();

EthernetNetIf net;
SuperTweetV1XML st(YOUR_ACCOUNT, YOUR_PASSWORD);

/**
 * Callback function for postStatusesUpdate.
 *
 * @param buf A pointer to a buffer.
 * @param siz A size of the buffer.
 */
void func(char *buf, size_t siz) {
#if 0
    /*
     * This is for checking a response.
     */
    for (int i = 0; i < siz; i++) {
        printf("%c", buf[i]);
    }
#endif
}

/**
 * Entry point.
 */
int main() {
    char text[BUFSIZ];
    int cnt = 0;

    EthernetErr err = net.setup();
    if (err) {
        error("Network setup failed.\n");
    }

    while (1) {
        snprintf(text, sizeof(text), "Hi! I'm mbed from ARM. Message number is %d", cnt++);
        HTTPResult r = st.postStatusesUpdate(std::string(text), func);
        printf("r=%d\n", (int)r);

        /*
         * Note:
         * I don't know why sometime it get a error.
         * I think it a bug in a mbed library.
         */
        if (r != 0) {
            printf("Resetting...\n");
            mbed_reset();
        }

        wait(5);
    }
}
