/**
 * SuperTweet API interface driver. (Version 0.0.1)
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

#include "SuperTweetV1XML.h"

/**
 * Create.
 *
 * @param account Account name.
 * @param password Password.
 */
SuperTweetV1XML::SuperTweetV1XML(const std::string account, const std::string password)
        : SuperTweet(account, password) {
}

/**
 * Dispose.
 */
SuperTweetV1XML::~SuperTweetV1XML() {
}

/**
 * Returns the 20 most recent statuses posted by the authenticating user.
 *
 * @param func A pointer to a callback function.
 * @return Result code.
 */
HTTPResult SuperTweetV1XML::getStatusesUserTimeline(void (*func)(char *buf, size_t siz)) {
    HTTPMap map;
    HTTPStream stream;
    const std::string url = URLBASE_V1 + "statuses/user_timeline.xml";
    char buf[BUFSIZ + 1] = {0};

    result = HTTP_OK;
    completed = false;
    stream.readNext((byte*)buf, sizeof(buf) - 1);
    HTTPResult r = client.get(url.c_str(), &stream, this, &SuperTweetV1XML::callback);
    while (!completed) {
        Net::poll();
        if (stream.readable()) {
            buf[stream.readLen()] = 0;
            if (func != NULL) {
                func(buf, stream.readLen());
            }
            stream.readNext((byte*)buf, sizeof(buf) - 1);
        }
    }
    return result;
}

/**
 * Returns the 20 most recent statuses, including retweets if they exist, posted by the authenticating user and the user's they follow.
 *
 * @param func A pointer to a callback function.
 * @return Result code.
 */
HTTPResult SuperTweetV1XML::getStatusesHomeTimeline(void (*func)(char *buf, size_t siz)) {
    HTTPMap map;
    HTTPStream stream;
    const std::string url = URLBASE_V1 + "statuses/home_timeline.xml";
    char buf[BUFSIZ + 1] = {0};

    result = HTTP_OK;
    completed = false;
    stream.readNext((byte*)buf, sizeof(buf) - 1);
    HTTPResult r = client.get(url.c_str(), &stream, this, &SuperTweetV1XML::callback);
    if (r != HTTP_OK) {
        while (!completed) {
            Net::poll();
            if (stream.readable()) {
                buf[stream.readLen()] = 0;
                if (func != NULL) {
                    func(buf, stream.readLen());
                }
                stream.readNext((byte*)buf, sizeof(buf) - 1);
            }
        }
    }
    return result;
}

/**
 * Updates the authenticating user's status.
 * A status update with text identical to the authenticating user's text identical
 * to the authenticating user's current status will be ignored to prevent duplicates.
 *
 * @param func A pointer to a callback function.
 * @return Result code.
 */
HTTPResult SuperTweetV1XML::postStatusesUpdate(const std::string datatext, void (*func)(char *buf, size_t siz)) {
    HTTPMap map;
    HTTPStream stream;
    map["status"] = datatext;
    const std::string url = URLBASE_V1 + "statuses/update.xml";
    char buf[BUFSIZ + 1] = {0};

    result = HTTP_OK;
    completed = false;
    stream.readNext((byte*)buf, sizeof(buf) - 1);
    HTTPResult r = client.post(url.c_str(), map, &stream, this, &SuperTweetV1XML::callback);
    while (!completed) {
        Net::poll();
        if (stream.readable()) {
            buf[stream.readLen()] = 0;
            if (func != NULL) {
                func(buf, stream.readLen());
            }
            stream.readNext((byte*)buf, sizeof(buf) - 1);
        }
    }
    return result;
}

void SuperTweetV1XML::callback(HTTPResult r) {
    result = r;
    completed = true;
}
