/**
 * SuperTweet API interface driver. (Version 0.0.1)
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

#include "SuperTweet.h"

const std::string SuperTweet::URLBASE_V1 = "http://api.supertweet.net/1/";

/**
 * Create.
 *
 * @param account Account name.
 * @param password Password.
 */
SuperTweet::SuperTweet(const std::string account, const std::string password)
        : account(account), password(password), client() {
    client.basicAuth(account.c_str(), password.c_str());
    client.setTimeout(10000);
}

/**
 * Dispose.
 */
SuperTweet::~SuperTweet() {
}

/**
 * Set timeout.
 *
 * @param ms Timeout. [ms]
 */
void SuperTweet::setTimeout(int ms) {
    client.setTimeout(ms);
}
