/**
 * SuperTweet API interface driver. (Version 0.0.1)
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

#include "SuperTweet.h"

/**
 * SuperTweet driver class.
 */
class SuperTweetV1XML : public SuperTweet {
public:

    /**
     * Create.
     *
     * @param account Account name.
     * @param password Password.
     */
    SuperTweetV1XML(const std::string account, const std::string password);

    /**
     * Dispose.
     */
    virtual ~SuperTweetV1XML();

    /**
     * Returns the 20 most recent statuses posted by the authenticating user.
     *
     * @param func A pointer to a callback function.
     * @return Result code.
     */
    virtual HTTPResult getStatusesUserTimeline(void (*func)(char *buf, size_t siz) = NULL);

    /**
     * Returns the 20 most recent statuses, including retweets if they exist, posted by the authenticating user and the user's they follow.
     *
     * @param func A pointer to a callback function.
     * @return Result code.
     */
    virtual HTTPResult getStatusesHomeTimeline(void (*func)(char *buf, size_t siz) = NULL);

    /**
     * Updates the authenticating user's status.
     * A status update with text identical to the authenticating user's text identical
     * to the authenticating user's current status will be ignored to prevent duplicates.
     *
     * @param func A pointer to a callback function.
     * @return Result code.
     */
    virtual HTTPResult postStatusesUpdate(const std::string datatext, void (*func)(char *buf, size_t siz) = NULL);
private:
    HTTPResult result;
    bool completed;
    void callback(HTTPResult r);
};
