/**
 * SuperTweet API interface driver. (Version 0.0.1)
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

#include <string>
#include "HTTPClient.h"

/**
 * SuperTweet driver class.
 */
class SuperTweet {
public:

    /**
     * Create.
     *
     * @param account Account name.
     * @param password Password.
     */
    SuperTweet(const std::string account, const std::string password);

    /**
     * Dispose.
     */
    virtual ~SuperTweet();

    /**
     * Set timeout.
     *
     * @param ms Timeout. [ms]
     */
    void setTimeout(int ms);

    /**
     * Returns the 20 most recent statuses posted by the authenticating user.
     *
     * @param func A pointer to a callback function.
     * @return Result code.
     */
    virtual HTTPResult getStatusesUserTimeline(void (*func)(char *buf, size_t siz) = NULL) = 0;

    /**
     * Returns the 20 most recent statuses, including retweets if they exist, posted by the authenticating user and the user's they follow.
     *
     * @param func A pointer to a callback function.
     * @return Result code.
     */
    virtual HTTPResult getStatusesHomeTimeline(void (*func)(char *buf, size_t siz) = NULL) = 0;

    /**
     * Updates the authenticating user's status.
     * A status update with text identical to the authenticating user's text identical
     * to the authenticating user's current status will be ignored to prevent duplicates.
     *
     * @param func A pointer to a callback function.
     * @return Result code.
     */
    virtual HTTPResult postStatusesUpdate(const std::string datatext, void (*func)(char *buf, size_t siz) = NULL) = 0;

protected:
    static const std::string URLBASE_V1;
    const std::string account;
    const std::string password;
    HTTPClient client;
};
