/**
 * =============================================================================
 * Expansion Board One - Example application No.2 (Version 0.0.1)
 * http://mbed.org/users/shintamainjp/notebook/starboard_expbrd-one_ex2_en/
 * =============================================================================
 * Copyright (c) 2010 Shinichiro Nakamura (CuBeatSystems)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * =============================================================================
 */

#include "mbed.h"
#include "PachubeV2CSV.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "ThermistorMCP9701.h"
#include "TextLCD.h"
#include "appconf.h"

/*
 * Definitions for a configuration file.
 */
#define CONFIG_FILENAME         "/local/SBOE2.CFG"

LocalFileSystem localfs("local");
TextLCD lcd(p24, p26, p27, p28, p29, p30);
EthernetNetIf netif;
BusOut led(LED1, LED2, LED3, LED4);
ThermistorMCP9701 thermistor1(p16);
ThermistorMCP9701 thermistor2(p17);
ThermistorMCP9701 thermistor3(p18);
ThermistorMCP9701 thermistor4(p19);
ThermistorMCP9701 thermistor5(p20);
static appconf_t appconf;

/**
 * Display a splash screen.
 */
void splash(void) {
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("StarBoard Orange");
    lcd.locate(0, 1);
    lcd.printf("Expansion Board ");
    wait(2);

    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("Example app No.2");
    lcd.locate(0, 1);
    lcd.printf("                ");
    wait(2);
}

/**
 * Convert double to char.
 *
 * @param val Value.
 * @param buf A pointer to a buffer.
 * @param bufsiz The buffer size.
 */
void convertDoubleToChar(double val, char *buf, size_t bufsiz) {
    snprintf(buf, bufsiz, "%f", val);
}

/**
 * Entry point.
 */
int main() {

    /*
     * Splash.
     */
    splash();

    /*
     * Initialize ethernet interface.
     */
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("Initializing.   ");
    lcd.locate(0, 1);
    lcd.printf("Ethernet:       ");
    EthernetErr ethErr = netif.setup();
    if (ethErr) {
        lcd.locate(0, 1);
        lcd.printf("Ethernet:NG     ");
        error("Network setup failed.\n");
    } else {
        lcd.locate(0, 1);
        lcd.printf("Ethernet:OK     ");
    }
    wait(2);

    /*
     * Read configuration variables from a file.
     */
    appconf_init(&appconf);
    if (appconf_read(CONFIG_FILENAME, &appconf) != 0) {
        lcd.cls();
        lcd.locate(0, 0);
        lcd.printf("ConfigFile");
        lcd.locate(0, 1);
        lcd.printf("Read error.");
        error("Failure to read a configuration file.\n");
    }

    /*
     * Check the interval time.
     */
    if (appconf.interval < 60) {
        lcd.cls();
        lcd.locate(0, 0);
        lcd.printf("Invalid interval");
        error("Inavlid interval time found.\n");
    }

    /*
     * Initialize objects.
     */
    PachubeV2CSV web(appconf.apikey);

    int cnt = 0;
    do {
        /*
         * Sense.
         */
        lcd.cls();
        int v1 = 0, v2 = 0, v3 = 0, v4 = 0, v5 = 0;
        for (int i = 0; i < appconf.interval; i++) {
            led = 1 << (i % 4);
            printf("%d/%d\n", i + 1, appconf.interval);
            v1 += thermistor1.read();
            v2 += thermistor2.read();
            v3 += thermistor3.read();
            v4 += thermistor4.read();
            v5 += thermistor5.read();
            lcd.locate(0, 0);
            lcd.printf("| 0| 1| 2| 3| 4|");
            lcd.locate(0, 1);
            lcd.printf("|%-2.0f|%-2.0f|%-2.0f|%-2.0f|%-2.0f|", thermistor1.read(), thermistor2.read(), thermistor3.read(), thermistor4.read(), thermistor5.read());
            wait(1);
        }
        v1 /= appconf.interval;
        v2 /= appconf.interval;
        v3 /= appconf.interval;
        v4 /= appconf.interval;
        v5 /= appconf.interval;

        /*
         * Post.
         */
        lcd.cls();
        lcd.locate(0, 0);
        lcd.printf("Posting No.%d", ++cnt);
        char val1[16];
        char val2[16];
        char val3[16];
        char val4[16];
        char val5[16];
        convertDoubleToChar(v1, val1, sizeof(val1));
        convertDoubleToChar(v2, val2, sizeof(val2));
        convertDoubleToChar(v3, val3, sizeof(val3));
        convertDoubleToChar(v4, val4, sizeof(val4));
        convertDoubleToChar(v5, val5, sizeof(val5));
        printf("updateDataStream(%d)\n", web.updateDataStream(atoi(appconf.feedid), "0", std::string(val1)));
        printf("updateDataStream(%d)\n", web.updateDataStream(atoi(appconf.feedid), "1", std::string(val2)));
        printf("updateDataStream(%d)\n", web.updateDataStream(atoi(appconf.feedid), "2", std::string(val3)));
        printf("updateDataStream(%d)\n", web.updateDataStream(atoi(appconf.feedid), "3", std::string(val4)));
        printf("updateDataStream(%d)\n", web.updateDataStream(atoi(appconf.feedid), "4", std::string(val5)));
    } while (1);
}
